/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Cube
extends GroupingElement {
    private final List<QualifiedName> columns;

    public Cube(List<QualifiedName> columns) {
        this(Optional.empty(), columns);
    }

    public Cube(NodeLocation location, List<QualifiedName> columns) {
        this(Optional.of(location), columns);
    }

    private Cube(Optional<NodeLocation> location, List<QualifiedName> columns) {
        super(location);
        Objects.requireNonNull(columns, "columns is null");
        this.columns = columns;
    }

    public List<QualifiedName> getColumns() {
        return this.columns;
    }

    @Override
    public List<Set<Expression>> enumerateGroupingSets() {
        return ImmutableList.copyOf((Collection)Sets.powerSet(this.columns.stream().map(QualifiedNameReference::new).collect(Collectors.toSet())));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cube cube = (Cube)o;
        return Objects.equals(this.columns, cube.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.columns);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columns", this.columns).toString();
    }
}

