/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Explain
extends Statement {
    private final Statement statement;
    private final boolean analyze;
    private final List<ExplainOption> options;

    public Explain(Statement statement, boolean analyze, List<ExplainOption> options) {
        this(Optional.empty(), analyze, statement, options);
    }

    public Explain(NodeLocation location, boolean analyze, Statement statement, List<ExplainOption> options) {
        this(Optional.of(location), analyze, statement, options);
    }

    private Explain(Optional<NodeLocation> location, boolean analyze, Statement statement, List<ExplainOption> options) {
        super(location);
        this.statement = Objects.requireNonNull(statement, "statement is null");
        this.analyze = analyze;
        this.options = options == null ? ImmutableList.of() : ImmutableList.copyOf(options);
    }

    public Statement getStatement() {
        return this.statement;
    }

    public boolean isAnalyze() {
        return this.analyze;
    }

    public List<ExplainOption> getOptions() {
        return this.options;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExplain(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.statement, this.options, this.analyze);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Explain o = (Explain)obj;
        return Objects.equals(this.statement, o.statement) && Objects.equals(this.options, o.options) && Objects.equals(this.analyze, o.analyze);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("statement", (Object)this.statement).add("options", this.options).add("analyze", this.analyze).toString();
    }
}

