/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.sql.parser.CaseInsensitiveStream;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.type.TypeCalculationBaseVisitor;
import com.facebook.presto.type.TypeCalculationLexer;
import com.facebook.presto.type.TypeCalculationParser;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;

public final class TypeCalculation {
    private static final BaseErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, e, line, charPositionInLine);
        }
    };

    private TypeCalculation() {
    }

    public static OptionalLong calculateLiteralValue(String calculation, Map<String, OptionalLong> inputs) {
        return TypeCalculation.calculateLiteralValue(calculation, inputs, true);
    }

    public static OptionalLong calculateLiteralValue(String calculation, Map<String, OptionalLong> inputs, boolean allowComplexExpression) {
        try {
            ParserRuleContext tree = TypeCalculation.parseTypeCalculation(calculation);
            if (!allowComplexExpression && !TypeCalculation.isSimpleExpression((ParseTree)tree)) {
                throw new IllegalArgumentException(String.format("Complex expressions not allowed, but got [%s]", calculation));
            }
            return (OptionalLong)new CalculateTypeVisitor(inputs).visit((ParseTree)tree);
        }
        catch (StackOverflowError e) {
            throw new ParsingException("Type calculation is too large (stack overflow while parsing)");
        }
    }

    private static ParserRuleContext parseTypeCalculation(String calculation) {
        TypeCalculationParser.TypeCalculationContext tree;
        TypeCalculationLexer lexer = new TypeCalculationLexer(new CaseInsensitiveStream((CharStream)new ANTLRInputStream(calculation)));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        TypeCalculationParser parser = new TypeCalculationParser((TokenStream)tokenStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        try {
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            tree = parser.typeCalculation();
        }
        catch (ParseCancellationException ex) {
            tokenStream.reset();
            parser.reset();
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            tree = parser.typeCalculation();
        }
        return tree;
    }

    private static boolean isSimpleExpression(ParseTree tree) {
        return (Boolean)new IsSimpleExpressionVisitor().visit(tree);
    }

    private static class CalculateTypeVisitor
    extends TypeCalculationBaseVisitor<OptionalLong> {
        private final Map<String, OptionalLong> inputs;

        public CalculateTypeVisitor(Map<String, OptionalLong> inputs) {
            this.inputs = Objects.requireNonNull(inputs);
        }

        @Override
        public OptionalLong visitTypeCalculation(TypeCalculationParser.TypeCalculationContext ctx) {
            return (OptionalLong)this.visit((ParseTree)ctx.expression());
        }

        @Override
        public OptionalLong visitArithmeticBinary(TypeCalculationParser.ArithmeticBinaryContext ctx) {
            OptionalLong left = (OptionalLong)this.visit((ParseTree)ctx.left);
            OptionalLong right = (OptionalLong)this.visit((ParseTree)ctx.right);
            if (!left.isPresent() || !right.isPresent()) {
                return OptionalLong.empty();
            }
            switch (ctx.operator.getType()) {
                case 4: {
                    return OptionalLong.of(left.getAsLong() + right.getAsLong());
                }
                case 5: {
                    return OptionalLong.of(left.getAsLong() - right.getAsLong());
                }
                case 6: {
                    return OptionalLong.of(left.getAsLong() * right.getAsLong());
                }
                case 7: {
                    return OptionalLong.of(left.getAsLong() / right.getAsLong());
                }
            }
            throw new IllegalStateException("Unsupported binary operator " + ctx.operator.getText());
        }

        @Override
        public OptionalLong visitArithmeticUnary(TypeCalculationParser.ArithmeticUnaryContext ctx) {
            OptionalLong value = (OptionalLong)this.visit((ParseTree)ctx.expression());
            if (!value.isPresent()) {
                return OptionalLong.empty();
            }
            switch (ctx.operator.getType()) {
                case 4: {
                    return value;
                }
                case 5: {
                    return OptionalLong.of(-value.getAsLong());
                }
            }
            throw new IllegalStateException("Unsupported unary operator " + ctx.operator.getText());
        }

        @Override
        public OptionalLong visitBinaryFunction(TypeCalculationParser.BinaryFunctionContext ctx) {
            OptionalLong left = (OptionalLong)this.visit((ParseTree)ctx.left);
            OptionalLong right = (OptionalLong)this.visit((ParseTree)ctx.right);
            if (!left.isPresent() || !right.isPresent()) {
                return OptionalLong.empty();
            }
            switch (ctx.binaryFunctionName().name.getType()) {
                case 9: {
                    return OptionalLong.of(Math.min(left.getAsLong(), right.getAsLong()));
                }
                case 10: {
                    return OptionalLong.of(Math.max(left.getAsLong(), right.getAsLong()));
                }
            }
            throw new IllegalArgumentException("Unsupported binary function " + ctx.binaryFunctionName().getText());
        }

        @Override
        public OptionalLong visitNumericLiteral(TypeCalculationParser.NumericLiteralContext ctx) {
            return OptionalLong.of(Long.parseLong(ctx.INTEGER_VALUE().getText()));
        }

        @Override
        public OptionalLong visitNullLiteral(TypeCalculationParser.NullLiteralContext ctx) {
            return OptionalLong.empty();
        }

        @Override
        public OptionalLong visitIdentifier(TypeCalculationParser.IdentifierContext ctx) {
            String identifier = ctx.getText();
            OptionalLong value = this.inputs.get(identifier.toUpperCase(Locale.US));
            if (value == null) {
                throw new IllegalArgumentException("No value for " + identifier);
            }
            return value;
        }

        @Override
        public OptionalLong visitParenthesizedExpression(TypeCalculationParser.ParenthesizedExpressionContext ctx) {
            return (OptionalLong)this.visit((ParseTree)ctx.expression());
        }
    }

    private static class IsSimpleExpressionVisitor
    extends TypeCalculationBaseVisitor<Boolean> {
        private IsSimpleExpressionVisitor() {
        }

        @Override
        public Boolean visitArithmeticBinary(TypeCalculationParser.ArithmeticBinaryContext ctx) {
            return false;
        }

        @Override
        public Boolean visitArithmeticUnary(TypeCalculationParser.ArithmeticUnaryContext ctx) {
            return false;
        }

        protected Boolean defaultResult() {
            return true;
        }

        protected Boolean aggregateResult(Boolean aggregate, Boolean nextResult) {
            return aggregate != false && nextResult != false;
        }
    }
}

