/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Preconditions;
import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.TpchEntity;
import java.util.Locale;

public class Order
implements TpchEntity {
    private final long rowNumber;
    private final long orderKey;
    private final long customerKey;
    private final char orderStatus;
    private final long totalPrice;
    private final int orderDate;
    private final String orderPriority;
    private final String clerk;
    private final long shipPriority;
    private final String comment;

    public Order(long rowNumber, long orderKey, long customerKey, char orderStatus, long totalPrice, int orderDate, String orderPriority, String clerk, long shipPriority, String comment) {
        this.rowNumber = rowNumber;
        this.orderKey = orderKey;
        this.customerKey = customerKey;
        this.orderStatus = orderStatus;
        this.totalPrice = totalPrice;
        this.orderDate = orderDate;
        this.orderPriority = (String)Preconditions.checkNotNull((Object)orderPriority, (Object)"orderPriority is null");
        this.clerk = (String)Preconditions.checkNotNull((Object)clerk, (Object)"clerk is null");
        this.shipPriority = shipPriority;
        this.comment = (String)Preconditions.checkNotNull((Object)comment, (Object)"comment is null");
    }

    @Override
    public long getRowNumber() {
        return this.rowNumber;
    }

    public long getOrderKey() {
        return this.orderKey;
    }

    public long getCustomerKey() {
        return this.customerKey;
    }

    public char getOrderStatus() {
        return this.orderStatus;
    }

    public double getTotalPrice() {
        return (double)this.totalPrice / 100.0;
    }

    public int getOrderDate() {
        return this.orderDate;
    }

    public String getOrderPriority() {
        return this.orderPriority;
    }

    public String getClerk() {
        return this.clerk;
    }

    public long getShipPriority() {
        return this.shipPriority;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toLine() {
        return String.format(Locale.ENGLISH, "%d|%d|%s|%s|%s|%s|%s|%d|%s|", this.orderKey, this.customerKey, Character.valueOf(this.orderStatus), GenerateUtils.formatMoney(this.totalPrice), GenerateUtils.formatDate(this.orderDate), this.orderPriority, this.clerk, this.shipPriority, this.comment);
    }
}

