/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.Order;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchColumnType;

public enum OrderColumn implements TpchColumn<Order>
{
    ORDER_KEY("orderkey", TpchColumnType.BIGINT){

        @Override
        public long getLong(Order order) {
            return order.getOrderKey();
        }
    }
    ,
    CUSTOMER_KEY("custkey", TpchColumnType.BIGINT){

        @Override
        public long getLong(Order order) {
            return order.getCustomerKey();
        }
    }
    ,
    ORDER_STATUS("orderstatus", TpchColumnType.VARCHAR){

        @Override
        public String getString(Order order) {
            return String.valueOf(order.getOrderStatus());
        }
    }
    ,
    TOTAL_PRICE("totalprice", TpchColumnType.DOUBLE){

        @Override
        public double getDouble(Order order) {
            return order.getTotalPrice();
        }
    }
    ,
    ORDER_DATE("orderdate", TpchColumnType.DATE){

        @Override
        public String getString(Order order) {
            return GenerateUtils.formatDate(this.getDate(order));
        }

        @Override
        public int getDate(Order order) {
            return order.getOrderDate();
        }
    }
    ,
    ORDER_PRIORITY("orderpriority", TpchColumnType.VARCHAR){

        @Override
        public String getString(Order order) {
            return order.getOrderPriority();
        }
    }
    ,
    CLERK("clerk", TpchColumnType.VARCHAR){

        @Override
        public String getString(Order order) {
            return order.getClerk();
        }
    }
    ,
    SHIP_PRIORITY("shippriority", TpchColumnType.BIGINT){

        @Override
        public long getLong(Order order) {
            return order.getShipPriority();
        }
    }
    ,
    COMMENT("comment", TpchColumnType.VARCHAR){

        @Override
        public String getString(Order order) {
            return order.getComment();
        }
    };

    private final String columnName;
    private final TpchColumnType type;

    private OrderColumn(String columnName, TpchColumnType type) {
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public TpchColumnType getType() {
        return this.type;
    }

    @Override
    public double getDouble(Order order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(Order order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(Order order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDate(Order entity) {
        throw new UnsupportedOperationException();
    }
}

