/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.Preconditions;
import io.airlift.tpch.GenerateUtils;
import io.airlift.tpch.TpchEntity;
import java.util.Locale;

public class Part
implements TpchEntity {
    private final long rowNumber;
    private final long partKey;
    private final String name;
    private final String manufacturer;
    private final String brand;
    private final String type;
    private final long size;
    private final String container;
    private final long retailPrice;
    private final String comment;

    public Part(long rowNumber, long partKey, String name, String manufacturer, String brand, String type, long size, String container, long retailPrice, String comment) {
        this.rowNumber = rowNumber;
        this.partKey = partKey;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.manufacturer = (String)Preconditions.checkNotNull((Object)manufacturer, (Object)"manufacturer is null");
        this.brand = (String)Preconditions.checkNotNull((Object)brand, (Object)"brand is null");
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.size = size;
        this.container = (String)Preconditions.checkNotNull((Object)container, (Object)"container is null");
        this.retailPrice = retailPrice;
        this.comment = (String)Preconditions.checkNotNull((Object)comment, (Object)"comment is null");
    }

    @Override
    public long getRowNumber() {
        return this.rowNumber;
    }

    public long getPartKey() {
        return this.partKey;
    }

    public String getName() {
        return this.name;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public String getContainer() {
        return this.container;
    }

    public double getRetailPrice() {
        return (double)this.retailPrice / 100.0;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toLine() {
        return String.format(Locale.ENGLISH, "%d|%s|%s|%s|%s|%d|%s|%s|%s|", this.partKey, this.name, this.manufacturer, this.brand, this.type, this.size, this.container, GenerateUtils.formatMoney(this.retailPrice), this.comment);
    }
}

