/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.nio.charset.StandardCharsets;

public final class TypeSerde {
    private TypeSerde() {
    }

    public static void writeType(SliceOutput sliceOutput, Type type) {
        if (sliceOutput == null) {
            throw new NullPointerException("sliceOutput is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        TypeSerde.writeLengthPrefixedString(sliceOutput, type.getTypeSignature().toString());
    }

    public static Type readType(TypeManager typeManager, SliceInput sliceInput) {
        if (sliceInput == null) {
            throw new NullPointerException("sliceInput is null");
        }
        String name = TypeSerde.readLengthPrefixedString(sliceInput);
        Type type = typeManager.getType(TypeSignature.parseTypeSignature(name));
        if (type == null) {
            throw new IllegalArgumentException("Unknown type " + name);
        }
        return type;
    }

    private static String readLengthPrefixedString(SliceInput input) {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void writeLengthPrefixedString(SliceOutput output, String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }
}

