/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.entity;

import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.HttpEntity;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.annotation.NotThreadSafe;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.entity.HttpEntityWrapper;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.util.EntityUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@NotThreadSafe
public class BufferedHttpEntity
extends HttpEntityWrapper {
    private final byte[] buffer;

    public BufferedHttpEntity(HttpEntity entity) throws IOException {
        super(entity);
        this.buffer = (byte[])(!entity.isRepeatable() || entity.getContentLength() < 0L ? EntityUtils.toByteArray(entity) : null);
    }

    public long getContentLength() {
        if (this.buffer != null) {
            return this.buffer.length;
        }
        return this.wrappedEntity.getContentLength();
    }

    public InputStream getContent() throws IOException {
        if (this.buffer != null) {
            return new ByteArrayInputStream(this.buffer);
        }
        return this.wrappedEntity.getContent();
    }

    public boolean isChunked() {
        return this.buffer == null && this.wrappedEntity.isChunked();
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        if (this.buffer != null) {
            outstream.write(this.buffer);
        } else {
            this.wrappedEntity.writeTo(outstream);
        }
    }

    public boolean isStreaming() {
        return this.buffer == null && this.wrappedEntity.isStreaming();
    }
}

