/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service;

import com.facebook.presto.hadoop.shaded.com.cloudera.com.jamesmurty.utils.XMLBuilder;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.HttpResponse;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.client.CredentialsProvider;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.client.HttpClient;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.client.methods.HttpDelete;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.client.methods.HttpGet;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.client.methods.HttpPost;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.client.methods.HttpPut;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.client.methods.HttpRequestBase;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.client.methods.HttpUriRequest;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.entity.StringEntity;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.params.HttpProtocolParams;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.protocol.HttpContext;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.apache.http.util.EntityUtils;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.CloudFrontServiceException;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.Constants;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.Jets3tProperties;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.ServiceException;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.impl.rest.CloudFrontXmlResponsesSaxParser;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.impl.rest.httpclient.JetS3tRequestAuthorizer;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.S3Object;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.cloudfront.CustomOrigin;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.cloudfront.Distribution;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.cloudfront.DistributionConfig;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.cloudfront.Invalidation;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.cloudfront.InvalidationList;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.cloudfront.InvalidationSummary;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.cloudfront.LoggingStatus;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.cloudfront.Origin;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.cloudfront.OriginAccessIdentity;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.cloudfront.OriginAccessIdentityConfig;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.cloudfront.S3Origin;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.cloudfront.StreamingDistribution;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.cloudfront.StreamingDistributionConfig;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.security.EncryptionUtil;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.security.ProviderCredentials;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.utils.RestUtils;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.utils.ServiceUtils;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudFrontService
implements JetS3tRequestAuthorizer {
    private static final Log log = LogFactory.getLog(CloudFrontService.class);
    public static final String ENDPOINT = "https://cloudfront.amazonaws.com/";
    public static final String VERSION = "2010-11-01";
    public static final String XML_NAMESPACE = "http://cloudfront.amazonaws.com/doc/2010-11-01/";
    public static final String DEFAULT_BUCKET_SUFFIX = ".s3.amazonaws.com";
    public static final String ORIGIN_ACCESS_IDENTITY_URI_PATH = "/origin-access-identity/cloudfront";
    public static final String ORIGIN_ACCESS_IDENTITY_PREFIX = "origin-access-identity/cloudfront/";
    protected HttpClient httpClient;
    private CredentialsProvider credentialsProvider;
    private ProviderCredentials credentials;
    protected Jets3tProperties jets3tProperties;
    private String invokingApplicationDescription;
    protected int internalErrorRetryMax = 5;
    protected long timeOffset = 0L;

    public CloudFrontService(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties) throws CloudFrontServiceException {
        this.credentials = credentials;
        this.invokingApplicationDescription = invokingApplicationDescription;
        this.credentialsProvider = credentialsProvider;
        if (jets3tProperties == null) {
            jets3tProperties = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME);
        }
        this.jets3tProperties = jets3tProperties;
        this.internalErrorRetryMax = jets3tProperties.getIntProperty("cloudfront-service.internal-error-retry-max", 5);
        this.initializeDefaults();
    }

    protected void initializeDefaults() {
        System.setProperty("networkaddress.cache.ttl", "300");
        System.setProperty("networkaddress.cache.negative.ttl", "1");
        this.httpClient = this.initHttpConnection();
        HttpProtocolParams.setUseExpectContinue(this.httpClient.getParams(), false);
        this.initializeProxy();
    }

    protected HttpClient initHttpConnection() {
        return RestUtils.initHttpConnection(this, this.jets3tProperties, this.invokingApplicationDescription, this.credentialsProvider);
    }

    protected void initializeProxy() {
        if (this.jets3tProperties.getBoolProperty("httpclient.proxy-autodetect", true)) {
            RestUtils.initHttpProxy(this.httpClient, this.jets3tProperties);
        } else {
            String proxyHostAddress = this.jets3tProperties.getStringProperty("httpclient.proxy-host", null);
            int proxyPort = this.jets3tProperties.getIntProperty("httpclient.proxy-port", -1);
            String proxyUser = this.jets3tProperties.getStringProperty("httpclient.proxy-user", null);
            String proxyPassword = this.jets3tProperties.getStringProperty("httpclient.proxy-password", null);
            String proxyDomain = this.jets3tProperties.getStringProperty("httpclient.proxy-domain", null);
            RestUtils.initHttpProxy(this.httpClient, this.jets3tProperties, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain);
        }
    }

    public CloudFrontService(ProviderCredentials credentials) throws CloudFrontServiceException {
        this(credentials, null, null, null);
    }

    public ProviderCredentials getAWSCredentials() {
        return this.credentials;
    }

    protected Date getCurrentTimeWithOffset() {
        return new Date(System.currentTimeMillis() + this.timeOffset);
    }

    @Override
    public void authorizeHttpRequest(HttpUriRequest httpMethod, HttpContext context) throws ServiceException {
        String date = ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset());
        httpMethod.setHeader("Date", date);
        String signature = ServiceUtils.signWithHmacSha1(this.getAWSCredentials().getSecretKey(), date);
        String authorizationString = "AWS " + this.getAWSCredentials().getAccessKey() + ":" + signature;
        httpMethod.setHeader("Authorization", authorizationString);
    }

    protected HttpResponse performRestRequest(HttpRequestBase httpMethod, int expectedResponseCode) throws CloudFrontServiceException {
        if (httpMethod.getFirstHeader("Date") == null) {
            httpMethod.setHeader("Date", ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset()));
        }
        HttpResponse response = null;
        boolean completedWithoutRecoverableError = true;
        int internalErrorCount = 0;
        try {
            do {
                completedWithoutRecoverableError = true;
                this.authorizeHttpRequest(httpMethod, null);
                response = this.httpClient.execute(httpMethod);
                int responseCode = response.getStatusLine().getStatusCode();
                if (responseCode == expectedResponseCode) continue;
                if (responseCode == 500) {
                    long delayMs = 1000L;
                    if (++internalErrorCount < this.internalErrorRetryMax) {
                        log.warn("Encountered " + internalErrorCount + " CloudFront Internal Server error(s), will retry in " + delayMs + "ms");
                        Thread.sleep(delayMs);
                        completedWithoutRecoverableError = false;
                        continue;
                    }
                    throw new CloudFrontServiceException("Encountered too many CloudFront Internal Server errors (" + internalErrorCount + "), aborting request.");
                }
                CloudFrontXmlResponsesSaxParser.ErrorHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseErrorResponse(response.getEntity().getContent());
                CloudFrontServiceException exception = new CloudFrontServiceException("Request failed with CloudFront Service error", responseCode, handler.getType(), handler.getCode(), handler.getMessage(), handler.getDetail(), handler.getRequestId());
                if ("RequestExpired".equals(exception.getErrorCode())) {
                    this.timeOffset = RestUtils.getAWSTimeAdjustment();
                    if (log.isWarnEnabled()) {
                        log.warn("Adjusted time offset in response to RequestExpired error. Local machine and CloudFront server disagree on the time by approximately " + this.timeOffset / 1000L + " seconds. Retrying connection.");
                    }
                    completedWithoutRecoverableError = false;
                    continue;
                }
                throw exception;
            } while (!completedWithoutRecoverableError);
        }
        catch (CloudFrontServiceException e) {
            this.releaseConnection(response);
            throw e;
        }
        catch (Throwable t) {
            this.releaseConnection(response);
            throw new CloudFrontServiceException("CloudFront Request failed", t);
        }
        return response;
    }

    private void releaseConnection(HttpResponse pResponse) {
        if (pResponse == null) {
            return;
        }
        try {
            EntityUtils.consume(pResponse.getEntity());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected List<Distribution> listDistributionsImpl(boolean isStreaming, int pagingSize) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Listing " + (isStreaming ? "streaming" : "") + " distributions for AWS user: " + this.getAWSCredentials().getAccessKey());
        }
        try {
            ArrayList<Distribution> distributions = new ArrayList<Distribution>();
            String nextMarker = null;
            boolean incompleteListing = true;
            do {
                String uri = "https://cloudfront.amazonaws.com/2010-11-01" + (isStreaming ? "/streaming-distribution" : "/distribution") + "?MaxItems=" + pagingSize;
                if (nextMarker != null) {
                    uri = uri + "&Marker=" + nextMarker;
                }
                HttpGet httpMethod = new HttpGet(uri);
                HttpResponse response = this.performRestRequest(httpMethod, 200);
                CloudFrontXmlResponsesSaxParser.DistributionListHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionListResponse(response.getEntity().getContent());
                distributions.addAll(handler.getDistributions());
                incompleteListing = handler.isTruncated();
                nextMarker = handler.getNextMarker();
                if (!incompleteListing || nextMarker != null) continue;
                throw new CloudFrontServiceException("Unable to retrieve paginated DistributionList results without a valid NextMarker value.");
            } while (incompleteListing);
            return distributions;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Distribution[] listDistributions(int pagingSize) throws CloudFrontServiceException {
        List<Distribution> distributions = this.listDistributionsImpl(false, pagingSize);
        return distributions.toArray(new Distribution[distributions.size()]);
    }

    public StreamingDistribution[] listStreamingDistributions(int pagingSize) throws CloudFrontServiceException {
        List<Distribution> distributions = this.listDistributionsImpl(true, pagingSize);
        return distributions.toArray(new StreamingDistribution[distributions.size()]);
    }

    public Distribution[] listDistributions() throws CloudFrontServiceException {
        return this.listDistributions(100);
    }

    public StreamingDistribution[] listStreamingDistributions() throws CloudFrontServiceException {
        return this.listStreamingDistributions(100);
    }

    public List<Distribution> listDistributionsByBucketName(boolean isStreaming, String bucketName) throws CloudFrontServiceException {
        String s3Endpoint = this.jets3tProperties.getStringProperty("s3service.s3-endpoint", Constants.S3_DEFAULT_HOSTNAME);
        if (log.isDebugEnabled()) {
            log.debug("Listing " + (isStreaming ? "streaming" : "") + " distributions for the S3 bucket '" + bucketName + "' for AWS user: " + this.getAWSCredentials().getAccessKey());
        }
        ArrayList<Distribution> bucketDistributions = new ArrayList<Distribution>();
        Distribution[] allDistributions = isStreaming ? this.listStreamingDistributions() : this.listDistributions();
        for (int i = 0; i < allDistributions.length; ++i) {
            S3Origin s3Origin;
            Origin origin = allDistributions[i].getOrigin();
            if (!(origin instanceof S3Origin) || !(s3Origin = (S3Origin)origin).getDnsName().equals(bucketName) && !bucketName.equals(ServiceUtils.findBucketNameInHostname(s3Origin.getDnsName(), s3Endpoint))) continue;
            bucketDistributions.add(allDistributions[i]);
        }
        return bucketDistributions;
    }

    public Distribution[] listDistributions(String bucketName) throws CloudFrontServiceException {
        List<Distribution> bucketDistributions = this.listDistributionsByBucketName(false, bucketName);
        return bucketDistributions.toArray(new Distribution[bucketDistributions.size()]);
    }

    public StreamingDistribution[] listStreamingDistributions(String bucketName) throws CloudFrontServiceException {
        List<Distribution> streamingDistributions = this.listDistributionsByBucketName(true, bucketName);
        return streamingDistributions.toArray(new StreamingDistribution[streamingDistributions.size()]);
    }

    protected XMLBuilder buildOrigin(Origin origin) throws TransformerException, ParserConfigurationException, FactoryConfigurationError {
        if (origin instanceof S3Origin) {
            S3Origin o = (S3Origin)origin;
            XMLBuilder builder = XMLBuilder.create("S3Origin").e("DNSName").t(CloudFrontService.sanitizeS3BucketName(origin.getDnsName())).up();
            if (o.getOriginAccessIdentity() != null) {
                builder.e("OriginAccessIdentity").t(o.getOriginAccessIdentity());
            }
            return builder;
        }
        CustomOrigin o = (CustomOrigin)origin;
        return XMLBuilder.create("CustomOrigin").e("DNSName").t(origin.getDnsName()).up().e("HTTPPort").t("" + o.getHttpPort()).up().e("HTTPSPort").t("" + o.getHttpsPort()).up().e("OriginProtocolPolicy").t(o.getOriginProtocolPolicy().toText());
    }

    protected String buildDistributionConfigXmlDocument(boolean isStreamingDistribution, Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject) throws TransformerException, ParserConfigurationException, FactoryConfigurationError {
        int i;
        XMLBuilder builder = XMLBuilder.create(isStreamingDistribution ? "StreamingDistributionConfig" : "DistributionConfig").a("xmlns", XML_NAMESPACE);
        builder.importXMLBuilder(this.buildOrigin(origin));
        builder.e("CallerReference").t(callerReference).up();
        for (int i2 = 0; i2 < cnames.length; ++i2) {
            builder.e("CNAME").t(cnames[i2]).up();
        }
        builder.e("Comment").t(comment).up().e("Enabled").t("" + enabled);
        if (defaultRootObject != null) {
            builder.e("DefaultRootObject").t(defaultRootObject).up();
        }
        if (trustedSignerSelf || trustedSignerAwsAccountNumbers != null && trustedSignerAwsAccountNumbers.length > 0) {
            XMLBuilder trustedSigners = builder.e("TrustedSigners");
            if (trustedSignerSelf) {
                trustedSigners.e("Self");
            }
            for (i = 0; trustedSignerAwsAccountNumbers != null && i < trustedSignerAwsAccountNumbers.length; ++i) {
                trustedSigners.e("AWSAccountNumber").t(trustedSignerAwsAccountNumbers[i]);
            }
            builder.up();
        }
        if (loggingStatus != null) {
            builder.e("Logging").e("Bucket").t(loggingStatus.getBucket()).up().e("Prefix").t(loggingStatus.getPrefix()).up().up();
        }
        if (requiredProtocols != null && requiredProtocols.length > 0) {
            XMLBuilder rpsBuilder = builder.e("RequiredProtocols");
            for (i = 0; i < requiredProtocols.length; ++i) {
                rpsBuilder.e("Protocol").t(requiredProtocols[i]).up();
            }
        }
        return builder.asString(null);
    }

    protected Distribution createDistributionImpl(boolean isStreaming, Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Creating " + (isStreaming ? "streaming" : "") + " distribution for origin: " + origin);
        }
        if (callerReference == null) {
            callerReference = "" + System.currentTimeMillis();
        }
        if (cnames == null) {
            cnames = new String[]{};
        }
        if (comment == null) {
            comment = "";
        }
        HttpPost httpMethod = new HttpPost("https://cloudfront.amazonaws.com/2010-11-01" + (isStreaming ? "/streaming-distribution" : "/distribution"));
        try {
            String distributionConfigXml = this.buildDistributionConfigXmlDocument(isStreaming, origin, callerReference, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, requiredProtocols, defaultRootObject);
            httpMethod.setEntity(new StringEntity(distributionConfigXml, "text/xml", Constants.DEFAULT_ENCODING));
            HttpResponse response = this.performRestRequest(httpMethod, 201);
            CloudFrontXmlResponsesSaxParser.DistributionHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionResponse(response.getEntity().getContent());
            return handler.getDistribution();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Distribution createDistribution(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject) throws CloudFrontServiceException {
        return this.createDistributionImpl(false, origin, callerReference, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, requiredProtocols, defaultRootObject);
    }

    public Distribution createDistribution(Origin origin) throws CloudFrontServiceException {
        return this.createDistribution(origin, null, null, null, true, null);
    }

    public Distribution createDistribution(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus) throws CloudFrontServiceException {
        return this.createDistribution(origin, callerReference, cnames, comment, enabled, loggingStatus, false, null, null, null);
    }

    public Distribution createDistribution(DistributionConfig config) throws CloudFrontServiceException {
        return this.createDistribution(config.getOrigin(), config.getCallerReference(), config.getCNAMEs(), config.getComment(), config.isEnabled(), config.getLoggingStatus(), config.isTrustedSignerSelf(), config.getTrustedSignerAwsAccountNumbers(), config.getRequiredProtocols(), config.getDefaultRootObject());
    }

    public StreamingDistribution createStreamingDistribution(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers) throws CloudFrontServiceException {
        return (StreamingDistribution)this.createDistributionImpl(true, origin, callerReference, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, null, null);
    }

    public StreamingDistribution createStreamingDistribution(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus) throws CloudFrontServiceException {
        return (StreamingDistribution)this.createDistributionImpl(true, origin, callerReference, cnames, comment, enabled, loggingStatus, false, null, null, null);
    }

    protected Distribution getDistributionInfoImpl(boolean isStreaming, String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Getting information for " + (isStreaming ? "streaming" : "") + " distribution with id: " + id);
        }
        HttpGet httpMethod = new HttpGet("https://cloudfront.amazonaws.com/2010-11-01" + (isStreaming ? "/streaming-distribution/" : "/distribution/") + id);
        try {
            HttpResponse response = this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.DistributionHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionResponse(response.getEntity().getContent());
            return handler.getDistribution();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Distribution getDistributionInfo(String id) throws CloudFrontServiceException {
        return this.getDistributionInfoImpl(false, id);
    }

    public StreamingDistribution getStreamingDistributionInfo(String id) throws CloudFrontServiceException {
        return (StreamingDistribution)this.getDistributionInfoImpl(true, id);
    }

    protected DistributionConfig getDistributionConfigImpl(boolean isStreaming, String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Getting configuration for " + (isStreaming ? "streaming" : "") + " distribution with id: " + id);
        }
        HttpGet httpMethod = new HttpGet("https://cloudfront.amazonaws.com/2010-11-01" + (isStreaming ? "/streaming-distribution/" : "/distribution/") + id + "/config");
        try {
            HttpResponse response = this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.DistributionConfigHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionConfigResponse(response.getEntity().getContent());
            DistributionConfig config = handler.getDistributionConfig();
            config.setEtag(response.getFirstHeader("ETag").getValue());
            return config;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public DistributionConfig getDistributionConfig(String id) throws CloudFrontServiceException {
        return this.getDistributionConfigImpl(false, id);
    }

    public StreamingDistributionConfig getStreamingDistributionConfig(String id) throws CloudFrontServiceException {
        return (StreamingDistributionConfig)this.getDistributionConfigImpl(true, id);
    }

    protected DistributionConfig updateDistributionConfigImpl(boolean isStreaming, String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject) throws CloudFrontServiceException {
        DistributionConfig oldConfig;
        if (log.isDebugEnabled()) {
            log.debug("Updating configuration of " + (isStreaming ? "streaming" : "") + "distribution with id: " + id);
        }
        DistributionConfig distributionConfig = oldConfig = isStreaming ? this.getStreamingDistributionConfig(id) : this.getDistributionConfig(id);
        if (cnames == null) {
            cnames = oldConfig.getCNAMEs();
        }
        if (comment == null) {
            comment = oldConfig.getComment();
        }
        if (origin == null) {
            origin = oldConfig.getOrigin();
        }
        HttpPut httpMethod = new HttpPut("https://cloudfront.amazonaws.com/2010-11-01" + (isStreaming ? "/streaming-distribution/" : "/distribution/") + id + "/config");
        try {
            String distributionConfigXml = this.buildDistributionConfigXmlDocument(isStreaming, origin, oldConfig.getCallerReference(), cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, requiredProtocols, defaultRootObject);
            httpMethod.setEntity(new StringEntity(distributionConfigXml, "text/xml", Constants.DEFAULT_ENCODING));
            httpMethod.setHeader("If-Match", oldConfig.getEtag());
            HttpResponse response = this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.DistributionConfigHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseDistributionConfigResponse(response.getEntity().getContent());
            DistributionConfig config = handler.getDistributionConfig();
            config.setEtag(response.getFirstHeader("ETag").getValue());
            return config;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public DistributionConfig updateDistributionConfig(String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject) throws CloudFrontServiceException {
        return this.updateDistributionConfigImpl(false, id, origin, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, requiredProtocols, defaultRootObject);
    }

    public StreamingDistributionConfig updateStreamingDistributionConfig(String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus) throws CloudFrontServiceException {
        return (StreamingDistributionConfig)this.updateDistributionConfigImpl(true, id, origin, cnames, comment, enabled, loggingStatus, false, null, null, null);
    }

    public StreamingDistributionConfig updateStreamingDistributionConfig(String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers) throws CloudFrontServiceException {
        return (StreamingDistributionConfig)this.updateDistributionConfigImpl(true, id, origin, cnames, comment, enabled, loggingStatus, trustedSignerSelf, trustedSignerAwsAccountNumbers, null, null);
    }

    public DistributionConfig updateDistributionConfig(String id, Origin origin, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus) throws CloudFrontServiceException {
        return this.updateDistributionConfig(id, origin, cnames, comment, enabled, loggingStatus, false, null, null, null);
    }

    public DistributionConfig updateDistributionConfig(String id, DistributionConfig config) throws CloudFrontServiceException {
        return this.updateDistributionConfig(id, config.getOrigin(), config.getCNAMEs(), config.getComment(), config.isEnabled(), config.getLoggingStatus(), config.isTrustedSignerSelf(), config.getTrustedSignerAwsAccountNumbers(), config.getRequiredProtocols(), config.getDefaultRootObject());
    }

    public void disableDistributionForDeletion(String id) throws CloudFrontServiceException {
        this.updateDistributionConfig(id, null, new String[0], "Disabled prior to deletion", false, null);
    }

    public void disableStreamingDistributionForDeletion(String id) throws CloudFrontServiceException {
        this.updateStreamingDistributionConfig(id, null, new String[0], "Disabled prior to deletion", false, null);
    }

    protected void deleteDistributionImpl(boolean isStreaming, String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Deleting " + (isStreaming ? "streaming" : "") + "distribution with id: " + id);
        }
        DistributionConfig currentConfig = isStreaming ? this.getStreamingDistributionConfig(id) : this.getDistributionConfig(id);
        HttpDelete httpMethod = new HttpDelete("https://cloudfront.amazonaws.com/2010-11-01" + (isStreaming ? "/streaming-distribution/" : "/distribution/") + id);
        try {
            httpMethod.setHeader("If-Match", currentConfig.getEtag());
            HttpResponse response = this.performRestRequest(httpMethod, 204);
            this.releaseConnection(response);
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public void deleteDistribution(String id) throws CloudFrontServiceException {
        this.deleteDistributionImpl(false, id);
    }

    public void deleteStreamingDistribution(String id) throws CloudFrontServiceException {
        this.deleteDistributionImpl(true, id);
    }

    public OriginAccessIdentity createOriginAccessIdentity(String callerReference, String comment) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Creating origin access identity");
        }
        HttpPost httpMethod = new HttpPost("https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront");
        if (callerReference == null) {
            callerReference = "" + System.currentTimeMillis();
        }
        try {
            XMLBuilder builder = XMLBuilder.create("CloudFrontOriginAccessIdentityConfig").a("xmlns", XML_NAMESPACE).e("CallerReference").t(callerReference).up().e("Comment").t(comment);
            httpMethod.setEntity(new StringEntity(builder.asString(null), "text/xml", Constants.DEFAULT_ENCODING));
            HttpResponse response = this.performRestRequest(httpMethod, 201);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentity(response.getEntity().getContent());
            return handler.getOriginAccessIdentity();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public List<OriginAccessIdentity> getOriginAccessIdentityList() throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Getting list of origin access identities");
        }
        HttpGet httpMethod = new HttpGet("https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront");
        try {
            HttpResponse response = this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityListHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentityListResponse(response.getEntity().getContent());
            return handler.getOriginAccessIdentityList();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public OriginAccessIdentity getOriginAccessIdentity(String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Getting information for origin access identity with id: " + id);
        }
        HttpGet httpMethod = new HttpGet("https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront/" + id);
        try {
            HttpResponse response = this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentity(response.getEntity().getContent());
            return handler.getOriginAccessIdentity();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public OriginAccessIdentityConfig getOriginAccessIdentityConfig(String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Getting config for origin access identity with id: " + id);
        }
        HttpGet httpMethod = new HttpGet("https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront/" + id + "/config");
        try {
            HttpResponse response = this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityConfigHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentityConfig(response.getEntity().getContent());
            OriginAccessIdentityConfig config = handler.getOriginAccessIdentityConfig();
            config.setEtag(response.getFirstHeader("ETag").getValue());
            return config;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public OriginAccessIdentityConfig updateOriginAccessIdentityConfig(String id, String comment) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Updating configuration of origin access identity with id: " + id);
        }
        OriginAccessIdentityConfig oldConfig = this.getOriginAccessIdentityConfig(id);
        if (comment == null) {
            comment = oldConfig.getComment();
        }
        HttpPut httpMethod = new HttpPut("https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront/" + id + "/config");
        try {
            XMLBuilder builder = XMLBuilder.create("CloudFrontOriginAccessIdentityConfig").a("xmlns", XML_NAMESPACE).e("CallerReference").t(oldConfig.getCallerReference()).up().e("Comment").t(comment);
            httpMethod.setEntity(new StringEntity(builder.asString(null), "text/xml", Constants.DEFAULT_ENCODING));
            httpMethod.setHeader("If-Match", oldConfig.getEtag());
            HttpResponse response = this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.OriginAccessIdentityConfigHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseOriginAccessIdentityConfig(response.getEntity().getContent());
            OriginAccessIdentityConfig config = handler.getOriginAccessIdentityConfig();
            config.setEtag(response.getFirstHeader("ETag").getValue());
            return config;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public void deleteOriginAccessIdentity(String id) throws CloudFrontServiceException {
        if (log.isDebugEnabled()) {
            log.debug("Deleting origin access identity with id: " + id);
        }
        OriginAccessIdentityConfig currentConfig = this.getOriginAccessIdentityConfig(id);
        HttpDelete httpMethod = new HttpDelete("https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront/" + id);
        try {
            httpMethod.setHeader("If-Match", currentConfig.getEtag());
            HttpResponse response = this.performRestRequest(httpMethod, 204);
            this.releaseConnection(response);
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Invalidation invalidateObjects(String distributionId, String[] objectKeys, String callerReference) throws CloudFrontServiceException {
        HttpPost httpMethod = new HttpPost("https://cloudfront.amazonaws.com/2010-11-01/distribution/" + distributionId + "/invalidation");
        try {
            XMLBuilder builder = XMLBuilder.create("InvalidationBatch");
            for (String objectPath : objectKeys) {
                String encodedPath = RestUtils.encodeUrlPath(objectPath, "/");
                if (!encodedPath.startsWith("/")) {
                    encodedPath = "/" + encodedPath;
                }
                builder.e("Path").t(encodedPath);
            }
            builder.e("CallerReference").t(callerReference);
            httpMethod.setEntity(new StringEntity(builder.asString(null), "text/xml", Constants.DEFAULT_ENCODING));
            HttpResponse response = this.performRestRequest(httpMethod, 201);
            CloudFrontXmlResponsesSaxParser.InvalidationHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseInvalidationResponse(response.getEntity().getContent());
            return handler.getInvalidation();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public Invalidation invalidateObjects(String distributionId, S3Object[] objects, String callerReference) throws CloudFrontServiceException {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        return this.invalidateObjects(distributionId, objectKeys, callerReference);
    }

    public Invalidation getInvalidation(String distributionId, String invalidationId) throws CloudFrontServiceException {
        HttpGet httpMethod = new HttpGet("https://cloudfront.amazonaws.com/2010-11-01/distribution/" + distributionId + "/invalidation/" + invalidationId);
        try {
            HttpResponse response = this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.InvalidationHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseInvalidationResponse(response.getEntity().getContent());
            return handler.getInvalidation();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public InvalidationList listInvalidations(String distributionId, String nextMarker, int pagingSize) throws CloudFrontServiceException {
        try {
            String uri = "https://cloudfront.amazonaws.com/2010-11-01/distribution/" + distributionId + "/invalidation" + "?MaxItems=" + pagingSize;
            if (nextMarker != null) {
                uri = uri + "&Marker=" + nextMarker;
            }
            HttpGet httpMethod = new HttpGet(uri);
            HttpResponse response = this.performRestRequest(httpMethod, 200);
            CloudFrontXmlResponsesSaxParser.InvalidationListHandler handler = new CloudFrontXmlResponsesSaxParser(this.jets3tProperties).parseInvalidationListResponse(response.getEntity().getContent());
            return handler.getInvalidationList();
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public List<InvalidationSummary> listInvalidations(String distributionId) throws CloudFrontServiceException {
        try {
            ArrayList<InvalidationSummary> invalidationSummaries = new ArrayList<InvalidationSummary>();
            String nextMarker = null;
            boolean incompleteListing = true;
            do {
                InvalidationList invalidationList = this.listInvalidations(distributionId, nextMarker, 100);
                invalidationSummaries.addAll(invalidationList.getInvalidationSummaries());
                incompleteListing = invalidationList.isTruncated();
                nextMarker = invalidationList.getNextMarker();
                if (!incompleteListing || nextMarker != null) continue;
                throw new CloudFrontServiceException("Unable to retrieve paginated InvalidationList results without a valid NextMarker value.");
            } while (incompleteListing);
            return invalidationSummaries;
        }
        catch (CloudFrontServiceException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public static String sanitizeS3BucketName(String proposedBucketName) {
        if (!proposedBucketName.endsWith(DEFAULT_BUCKET_SUFFIX)) {
            log.warn("Bucket names used within the CloudFront service should be specified as full S3 subdomain paths like 'jets3t.s3.amazonaws.com'. Repairing faulty bucket name value \"" + proposedBucketName + "\" by adding suffix " + "'" + DEFAULT_BUCKET_SUFFIX + "'.");
            return proposedBucketName + DEFAULT_BUCKET_SUFFIX;
        }
        return proposedBucketName;
    }

    protected static String makeStringUrlSafe(String str) throws UnsupportedEncodingException {
        return ServiceUtils.toBase64(str.getBytes("UTF-8")).replace('+', '-').replace('=', '_').replace('/', '~');
    }

    protected static String makeBytesUrlSafe(byte[] bytes) throws UnsupportedEncodingException {
        return ServiceUtils.toBase64(bytes).replace('+', '-').replace('=', '_').replace('/', '~');
    }

    public static String buildPolicyForSignedUrl(String resourcePath, Date epochDateLessThan, String limitToIpAddressCIDR, Date epochDateGreaterThan) throws CloudFrontServiceException {
        if (epochDateLessThan == null) {
            throw new CloudFrontServiceException("epochDateLessThan must be provided to sign CloudFront URLs");
        }
        if (resourcePath == null) {
            resourcePath = "*";
        }
        String ipAddress = limitToIpAddressCIDR == null ? "0.0.0.0/0" : limitToIpAddressCIDR;
        String policy = "{\"Statement\": [{\"Resource\":\"" + resourcePath + "\"" + ",\"Condition\":{" + "\"DateLessThan\":{\"AWS:EpochTime\":" + epochDateLessThan.getTime() / 1000L + "}" + ",\"IpAddress\":{\"AWS:SourceIp\":\"" + ipAddress + "\"}" + (epochDateGreaterThan == null ? "" : ",\"DateGreaterThan\":{\"AWS:EpochTime\":" + epochDateGreaterThan.getTime() / 1000L + "}") + "}}]}";
        return policy;
    }

    public static String signUrl(String resourceUrlOrPath, String keyPairId, byte[] derPrivateKey, String policy) throws CloudFrontServiceException {
        try {
            byte[] signatureBytes = EncryptionUtil.signWithRsaSha1(derPrivateKey, policy.getBytes("UTF-8"));
            String urlSafePolicy = CloudFrontService.makeStringUrlSafe(policy);
            String urlSafeSignature = CloudFrontService.makeBytesUrlSafe(signatureBytes);
            String signedUrl = resourceUrlOrPath + (resourceUrlOrPath.indexOf(63) >= 0 ? "&" : "?") + "Policy=" + urlSafePolicy + "&Signature=" + urlSafeSignature + "&Key-Pair-Id=" + keyPairId;
            return signedUrl;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }

    public static String signUrlCanned(String resourceUrlOrPath, String keyPairId, byte[] derPrivateKey, Date epochDateLessThan) throws CloudFrontServiceException {
        try {
            String cannedPolicy = "{\"Statement\":[{\"Resource\":\"" + resourceUrlOrPath + "\",\"Condition\":{\"DateLessThan\":{\"AWS:EpochTime\":" + epochDateLessThan.getTime() / 1000L + "}}}]}";
            byte[] signatureBytes = EncryptionUtil.signWithRsaSha1(derPrivateKey, cannedPolicy.getBytes("UTF-8"));
            String urlSafeSignature = CloudFrontService.makeBytesUrlSafe(signatureBytes);
            String signedUrl = resourceUrlOrPath + (resourceUrlOrPath.indexOf(63) >= 0 ? "&" : "?") + "Expires=" + epochDateLessThan.getTime() / 1000L + "&Signature=" + urlSafeSignature + "&Key-Pair-Id=" + keyPairId;
            return signedUrl;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudFrontServiceException(e);
        }
    }
}

