/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.multi.s3;

import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.MultipartUpload;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.StorageObject;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.multi.ThreadWatcher;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.multi.event.ServiceEvent;

public class MultipartStartsEvent
extends ServiceEvent {
    private MultipartUpload[] completedMultipartUploads = null;
    private StorageObject[] incompletedObjects = null;

    private MultipartStartsEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static MultipartStartsEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        MultipartStartsEvent event = new MultipartStartsEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static MultipartStartsEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        MultipartStartsEvent event = new MultipartStartsEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static MultipartStartsEvent newInProgressEvent(ThreadWatcher threadWatcher, MultipartUpload[] completedMultipartUploads, Object uniqueOperationId) {
        MultipartStartsEvent event = new MultipartStartsEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setCompletedUploads(completedMultipartUploads);
        return event;
    }

    public static MultipartStartsEvent newCompletedEvent(Object uniqueOperationId) {
        MultipartStartsEvent event = new MultipartStartsEvent(2, uniqueOperationId);
        return event;
    }

    public static MultipartStartsEvent newCancelledEvent(StorageObject[] incompletedObjects, Object uniqueOperationId) {
        MultipartStartsEvent event = new MultipartStartsEvent(4, uniqueOperationId);
        event.setIncompletedObjects(incompletedObjects);
        return event;
    }

    public static MultipartStartsEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        MultipartStartsEvent event = new MultipartStartsEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setIncompletedObjects(StorageObject[] objects) {
        this.incompletedObjects = objects;
    }

    private void setCompletedUploads(MultipartUpload[] uploads) {
        this.completedMultipartUploads = uploads;
    }

    public MultipartUpload[] getStartedUploads() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Started Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.completedMultipartUploads;
    }

    public StorageObject[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.incompletedObjects;
    }
}

