/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.multithread;

import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.S3Bucket;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.multithread.ServiceEvent;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.multithread.ThreadWatcher;

public class CreateBucketsEvent
extends ServiceEvent {
    private S3Bucket[] buckets = null;

    private CreateBucketsEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static CreateBucketsEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        CreateBucketsEvent event = new CreateBucketsEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static CreateBucketsEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        CreateBucketsEvent event = new CreateBucketsEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static CreateBucketsEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Bucket[] completedBuckets, Object uniqueOperationId) {
        CreateBucketsEvent event = new CreateBucketsEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setBuckets(completedBuckets);
        return event;
    }

    public static CreateBucketsEvent newCompletedEvent(Object uniqueOperationId) {
        CreateBucketsEvent event = new CreateBucketsEvent(2, uniqueOperationId);
        return event;
    }

    public static CreateBucketsEvent newCancelledEvent(S3Bucket[] incompletedBuckets, Object uniqueOperationId) {
        CreateBucketsEvent event = new CreateBucketsEvent(4, uniqueOperationId);
        event.setBuckets(incompletedBuckets);
        return event;
    }

    public static CreateBucketsEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        CreateBucketsEvent event = new CreateBucketsEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setBuckets(S3Bucket[] buckets) {
        this.buckets = buckets;
    }

    public S3Bucket[] getCreatedBuckets() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Created Buckets are only available from EVENT_IN_PROGRESS events");
        }
        return this.buckets;
    }

    public S3Bucket[] getCancelledBuckets() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Buckets are  only available from EVENT_CANCELLED events");
        }
        return this.buckets;
    }
}

