/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.shaded.org.apache.avro.file;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class LengthLimitedInputStream
extends FilterInputStream {
    private long remaining;

    protected LengthLimitedInputStream(InputStream in, long maxLength) {
        super(in);
        this.remaining = maxLength;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining > 0L) {
            int v = super.read();
            if (v != -1) {
                --this.remaining;
            }
            return v;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private int remainingInt() {
        return (int)Math.min(this.remaining, Integer.MAX_VALUE);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int v;
        if (this.remaining == 0L) {
            return -1;
        }
        if ((long)len > this.remaining) {
            len = this.remainingInt();
        }
        if ((v = super.read(b, off, len)) != -1) {
            this.remaining -= (long)v;
        }
        return v;
    }

    @Override
    public int available() throws IOException {
        return Math.min(super.available(), this.remainingInt());
    }

    @Override
    public long skip(long n) throws IOException {
        long v = super.skip(Math.min(this.remaining, n));
        this.remaining -= v;
        return v;
    }
}

