/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.facebook.presto.hadoop.shaded.com.google.common.cache.Cache;
import com.facebook.presto.hadoop.shaded.com.google.common.cache.CacheBuilder;
import com.facebook.presto.hadoop.shaded.org.apache.commons.io.IOUtils;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.net.unix.DomainSocket;

class DomainSocketFactory {
    public static final Log LOG = LogFactory.getLog(DomainSocketFactory.class);
    private final DFSClient.Conf conf;
    Cache<String, PathStatus> pathInfo = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public DomainSocketFactory(DFSClient.Conf conf) {
        this.conf = conf;
        String feature = null;
        if (conf.shortCircuitLocalReads && !conf.useLegacyBlockReaderLocal) {
            feature = "The short-circuit local reads feature";
        } else if (conf.domainSocketDataTraffic) {
            feature = "UNIX domain socket data traffic";
        }
        if (feature != null) {
            if (conf.domainSocketPath.isEmpty()) {
                LOG.warn(feature + " is disabled because you have not set " + "dfs.domain.socket.path");
            } else if (DomainSocket.getLoadingFailureReason() != null) {
                LOG.warn(feature + " is disabled because " + DomainSocket.getLoadingFailureReason());
            } else {
                LOG.debug(feature + "is enabled.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DomainSocket create(InetSocketAddress addr, DFSInputStream stream) {
        if (this.conf.domainSocketPath.isEmpty()) {
            return null;
        }
        if (!(this.conf.domainSocketDataTraffic || this.conf.shortCircuitLocalReads && !this.conf.useLegacyBlockReaderLocal)) {
            return null;
        }
        if (!DFSClient.isLocalAddress(addr)) {
            return null;
        }
        if (DomainSocket.getLoadingFailureReason() != null) {
            return null;
        }
        String escapedPath = DomainSocket.getEffectivePath(this.conf.domainSocketPath, addr.getPort());
        PathStatus info = this.pathInfo.getIfPresent(escapedPath);
        if (info == PathStatus.UNUSABLE) {
            return null;
        }
        if (!this.conf.domainSocketDataTraffic && (info == PathStatus.SHORT_CIRCUIT_DISABLED || stream.shortCircuitForbidden())) {
            return null;
        }
        boolean success = false;
        DomainSocket sock = null;
        try {
            sock = DomainSocket.connect(escapedPath);
            sock.setAttribute(4, this.conf.socketTimeout);
            success = true;
        }
        catch (IOException e) {
            LOG.warn("error creating DomainSocket", e);
        }
        finally {
            if (!success) {
                if (sock != null) {
                    IOUtils.closeQuietly(sock);
                }
                this.pathInfo.put(escapedPath, PathStatus.UNUSABLE);
                sock = null;
            }
        }
        return sock;
    }

    public void disableShortCircuitForPath(String path) {
        this.pathInfo.put(path, PathStatus.SHORT_CIRCUIT_DISABLED);
    }

    public void disableDomainSocketPath(String path) {
        this.pathInfo.put(path, PathStatus.UNUSABLE);
    }

    static enum PathStatus {
        UNUSABLE,
        SHORT_CIRCUIT_DISABLED;

    }
}

