/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;

@InterfaceAudience.Private
public class HdfsConstants {
    public static final String CLIENT_NAMENODE_PROTOCOL_NAME = "org.apache.hadoop.hdfs.protocol.ClientProtocol";
    public static final String CLIENT_DATANODE_PROTOCOL_NAME = "org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol";
    public static int MIN_BLOCKS_FOR_WRITE = 5;
    public static final long QUOTA_DONT_SET = Long.MAX_VALUE;
    public static final long QUOTA_RESET = -1L;
    public static final long LEASE_SOFTLIMIT_PERIOD = 60000L;
    public static final long LEASE_HARDLIMIT_PERIOD = 3600000L;
    public static final long LEASE_RECOVER_PERIOD = 10000L;
    public static int MAX_PATH_LENGTH = 8000;
    public static int MAX_PATH_DEPTH = 1000;
    public static final int DEFAULT_DATA_SOCKET_SIZE = 131072;
    public static final int IO_FILE_BUFFER_SIZE = new HdfsConfiguration().getInt("io.file.buffer.size", 4096);
    public static final int SMALL_BUFFER_SIZE = Math.min(IO_FILE_BUFFER_SIZE / 2, 512);
    public static final int BYTES_IN_INTEGER = 4;
    public static final long INVALID_TXID = -12345L;
    public static final String HDFS_URI_SCHEME = "hdfs";
    public static final String HA_DT_SERVICE_PREFIX = "ha-hdfs:";
    public static final int LAYOUT_VERSION = LayoutVersion.getCurrentLayoutVersion();

    protected HdfsConstants() {
    }

    public static enum UpgradeAction {
        GET_STATUS,
        DETAILED_STATUS,
        FORCE_PROCEED;

    }

    public static enum DatanodeReportType {
        ALL,
        LIVE,
        DEAD;

    }

    public static enum SafeModeAction {
        SAFEMODE_LEAVE,
        SAFEMODE_ENTER,
        SAFEMODE_GET;

    }
}

