/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.facebook.presto.hadoop.shaded.com.google.protobuf.RpcController;
import com.facebook.presto.hadoop.shaded.com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;

public class DatanodeProtocolServerSideTranslatorPB
implements DatanodeProtocolPB {
    private final DatanodeProtocol impl;
    private static final DatanodeProtocolProtos.ErrorReportResponseProto ERROR_REPORT_RESPONSE_PROTO = DatanodeProtocolProtos.ErrorReportResponseProto.newBuilder().build();
    private static final DatanodeProtocolProtos.BlockReceivedAndDeletedResponseProto BLOCK_RECEIVED_AND_DELETE_RESPONSE = DatanodeProtocolProtos.BlockReceivedAndDeletedResponseProto.newBuilder().build();
    private static final DatanodeProtocolProtos.ReportBadBlocksResponseProto REPORT_BAD_BLOCK_RESPONSE = DatanodeProtocolProtos.ReportBadBlocksResponseProto.newBuilder().build();
    private static final DatanodeProtocolProtos.CommitBlockSynchronizationResponseProto COMMIT_BLOCK_SYNCHRONIZATION_RESPONSE_PROTO = DatanodeProtocolProtos.CommitBlockSynchronizationResponseProto.newBuilder().build();

    public DatanodeProtocolServerSideTranslatorPB(DatanodeProtocol impl) {
        this.impl = impl;
    }

    @Override
    public DatanodeProtocolProtos.RegisterDatanodeResponseProto registerDatanode(RpcController controller, DatanodeProtocolProtos.RegisterDatanodeRequestProto request) throws ServiceException {
        DatanodeRegistration registrationResp;
        DatanodeRegistration registration = PBHelper.convert(request.getRegistration());
        try {
            registrationResp = this.impl.registerDatanode(registration);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return DatanodeProtocolProtos.RegisterDatanodeResponseProto.newBuilder().setRegistration(PBHelper.convert(registrationResp)).build();
    }

    @Override
    public DatanodeProtocolProtos.HeartbeatResponseProto sendHeartbeat(RpcController controller, DatanodeProtocolProtos.HeartbeatRequestProto request) throws ServiceException {
        HeartbeatResponse response;
        int i;
        try {
            List<DatanodeProtocolProtos.StorageReportProto> list = request.getReportsList();
            StorageReport[] report = new StorageReport[list.size()];
            i = 0;
            for (DatanodeProtocolProtos.StorageReportProto p : list) {
                report[i++] = new StorageReport(p.getStorageID(), p.getFailed(), p.getCapacity(), p.getDfsUsed(), p.getRemaining(), p.getBlockPoolUsed());
            }
            response = this.impl.sendHeartbeat(PBHelper.convert(request.getRegistration()), report, request.getXmitsInProgress(), request.getXceiverCount(), request.getFailedVolumes());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        DatanodeProtocolProtos.HeartbeatResponseProto.Builder builder = DatanodeProtocolProtos.HeartbeatResponseProto.newBuilder();
        DatanodeCommand[] cmds = response.getCommands();
        if (cmds != null) {
            for (i = 0; i < cmds.length; ++i) {
                if (cmds[i] == null) continue;
                builder.addCmds(PBHelper.convert(cmds[i]));
            }
        }
        builder.setHaStatus(PBHelper.convert(response.getNameNodeHaState()));
        return builder.build();
    }

    @Override
    public DatanodeProtocolProtos.BlockReportResponseProto blockReport(RpcController controller, DatanodeProtocolProtos.BlockReportRequestProto request) throws ServiceException {
        DatanodeCommand cmd = null;
        StorageBlockReport[] report = new StorageBlockReport[request.getReportsCount()];
        int index = 0;
        for (DatanodeProtocolProtos.StorageBlockReportProto s : request.getReportsList()) {
            List<Long> blockIds = s.getBlocksList();
            long[] blocks = new long[blockIds.size()];
            for (int i = 0; i < blockIds.size(); ++i) {
                blocks[i] = blockIds.get(i);
            }
            report[index++] = new StorageBlockReport(PBHelper.convert(s.getStorage()), blocks);
        }
        try {
            cmd = this.impl.blockReport(PBHelper.convert(request.getRegistration()), request.getBlockPoolId(), report);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        DatanodeProtocolProtos.BlockReportResponseProto.Builder builder = DatanodeProtocolProtos.BlockReportResponseProto.newBuilder();
        if (cmd != null) {
            builder.setCmd(PBHelper.convert(cmd));
        }
        return builder.build();
    }

    @Override
    public DatanodeProtocolProtos.BlockReceivedAndDeletedResponseProto blockReceivedAndDeleted(RpcController controller, DatanodeProtocolProtos.BlockReceivedAndDeletedRequestProto request) throws ServiceException {
        List<DatanodeProtocolProtos.StorageReceivedDeletedBlocksProto> sBlocks = request.getBlocksList();
        StorageReceivedDeletedBlocks[] info = new StorageReceivedDeletedBlocks[sBlocks.size()];
        for (int i = 0; i < sBlocks.size(); ++i) {
            DatanodeProtocolProtos.StorageReceivedDeletedBlocksProto sBlock = sBlocks.get(i);
            List<DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto> list = sBlock.getBlocksList();
            ReceivedDeletedBlockInfo[] rdBlocks = new ReceivedDeletedBlockInfo[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                rdBlocks[j] = PBHelper.convert(list.get(j));
            }
            info[i] = new StorageReceivedDeletedBlocks(sBlock.getStorageID(), rdBlocks);
        }
        try {
            this.impl.blockReceivedAndDeleted(PBHelper.convert(request.getRegistration()), request.getBlockPoolId(), info);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return BLOCK_RECEIVED_AND_DELETE_RESPONSE;
    }

    @Override
    public DatanodeProtocolProtos.ErrorReportResponseProto errorReport(RpcController controller, DatanodeProtocolProtos.ErrorReportRequestProto request) throws ServiceException {
        try {
            this.impl.errorReport(PBHelper.convert(request.getRegistartion()), request.getErrorCode(), request.getMsg());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return ERROR_REPORT_RESPONSE_PROTO;
    }

    @Override
    public HdfsProtos.VersionResponseProto versionRequest(RpcController controller, HdfsProtos.VersionRequestProto request) throws ServiceException {
        NamespaceInfo info;
        try {
            info = this.impl.versionRequest();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return HdfsProtos.VersionResponseProto.newBuilder().setInfo(PBHelper.convert(info)).build();
    }

    @Override
    public DatanodeProtocolProtos.ProcessUpgradeResponseProto processUpgrade(RpcController controller, DatanodeProtocolProtos.ProcessUpgradeRequestProto request) throws ServiceException {
        UpgradeCommand ret;
        try {
            UpgradeCommand cmd = request.hasCmd() ? PBHelper.convert(request.getCmd()) : null;
            ret = this.impl.processUpgradeCommand(cmd);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        DatanodeProtocolProtos.ProcessUpgradeResponseProto.Builder builder = DatanodeProtocolProtos.ProcessUpgradeResponseProto.newBuilder();
        if (ret != null) {
            builder.setCmd(PBHelper.convert(ret));
        }
        return builder.build();
    }

    @Override
    public DatanodeProtocolProtos.ReportBadBlocksResponseProto reportBadBlocks(RpcController controller, DatanodeProtocolProtos.ReportBadBlocksRequestProto request) throws ServiceException {
        List<HdfsProtos.LocatedBlockProto> lbps = request.getBlocksList();
        LocatedBlock[] blocks = new LocatedBlock[lbps.size()];
        for (int i = 0; i < lbps.size(); ++i) {
            blocks[i] = PBHelper.convert(lbps.get(i));
        }
        try {
            this.impl.reportBadBlocks(blocks);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return REPORT_BAD_BLOCK_RESPONSE;
    }

    @Override
    public DatanodeProtocolProtos.CommitBlockSynchronizationResponseProto commitBlockSynchronization(RpcController controller, DatanodeProtocolProtos.CommitBlockSynchronizationRequestProto request) throws ServiceException {
        List<HdfsProtos.DatanodeIDProto> dnprotos = request.getNewTaragetsList();
        DatanodeID[] dns = new DatanodeID[dnprotos.size()];
        for (int i = 0; i < dnprotos.size(); ++i) {
            dns[i] = PBHelper.convert(dnprotos.get(i));
        }
        List<String> sidprotos = request.getNewTargetStoragesList();
        String[] storageIDs = sidprotos.toArray(new String[sidprotos.size()]);
        try {
            this.impl.commitBlockSynchronization(PBHelper.convert(request.getBlock()), request.getNewGenStamp(), request.getNewLength(), request.getCloseFile(), request.getDeleteBlock(), dns, storageIDs);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return COMMIT_BLOCK_SYNCHRONIZATION_RESPONSE_PROTO;
    }
}

