/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.facebook.presto.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import com.facebook.presto.hadoop.shaded.com.google.common.base.Function;
import com.facebook.presto.hadoop.shaded.com.google.common.base.Joiner;
import com.facebook.presto.hadoop.shaded.com.google.common.base.Preconditions;
import com.facebook.presto.hadoop.shaded.com.google.common.collect.HashMultimap;
import com.facebook.presto.hadoop.shaded.com.google.common.collect.Iterators;
import com.facebook.presto.hadoop.shaded.com.google.common.collect.Multimap;
import com.facebook.presto.hadoop.shaded.com.google.common.collect.UnmodifiableIterator;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.util.HostsFileReader;

class HostFileManager {
    private static final Log LOG = LogFactory.getLog(HostFileManager.class);
    private HostSet includes = new HostSet();
    private HostSet excludes = new HostSet();

    HostFileManager() {
    }

    private static HostSet readFile(String type, String filename) throws IOException {
        HostSet res = new HostSet();
        if (!filename.isEmpty()) {
            HashSet<String> entrySet = new HashSet<String>();
            HostsFileReader.readFileToSet(type, filename, entrySet);
            for (String str : entrySet) {
                InetSocketAddress addr = HostFileManager.parseEntry(type, filename, str);
                if (addr == null) continue;
                res.add(addr);
            }
        }
        return res;
    }

    @VisibleForTesting
    static InetSocketAddress parseEntry(String type, String fn, String line) {
        try {
            URI uri = new URI("dummy", line, null, null, null);
            int port = uri.getPort() == -1 ? 0 : uri.getPort();
            InetSocketAddress addr = new InetSocketAddress(uri.getHost(), port);
            if (addr.isUnresolved()) {
                LOG.warn(String.format("Failed to resolve address `%s` in `%s`. Ignoring in the %s list.", line, fn, type));
                return null;
            }
            return addr;
        }
        catch (URISyntaxException e) {
            LOG.warn(String.format("Failed to parse `%s` in `%s`. Ignoring in the %s list.", line, fn, type));
            return null;
        }
    }

    static InetSocketAddress resolvedAddressFromDatanodeID(DatanodeID id) {
        return new InetSocketAddress(id.getIpAddr(), id.getXferPort());
    }

    synchronized HostSet getIncludes() {
        return this.includes;
    }

    synchronized HostSet getExcludes() {
        return this.excludes;
    }

    synchronized boolean isIncluded(DatanodeID dn) {
        return this.includes.isEmpty() || this.includes.match(HostFileManager.resolvedAddressFromDatanodeID(dn));
    }

    synchronized boolean isExcluded(DatanodeID dn) {
        return this.excludes.match(HostFileManager.resolvedAddressFromDatanodeID(dn));
    }

    synchronized boolean hasIncludes() {
        return !this.includes.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(String includeFile, String excludeFile) throws IOException {
        HostSet newIncludes = HostFileManager.readFile("included", includeFile);
        HostSet newExcludes = HostFileManager.readFile("excluded", excludeFile);
        HostFileManager hostFileManager = this;
        synchronized (hostFileManager) {
            this.includes = newIncludes;
            this.excludes = newExcludes;
        }
    }

    static class HostSet
    implements Iterable<InetSocketAddress> {
        private final Multimap<InetAddress, Integer> addrs = HashMultimap.create();

        HostSet() {
        }

        boolean matchedBy(InetSocketAddress addr) {
            Collection<Integer> ports = this.addrs.get(addr.getAddress());
            return addr.getPort() == 0 ? !ports.isEmpty() : ports.contains(addr.getPort());
        }

        boolean match(InetSocketAddress addr) {
            int port = addr.getPort();
            Collection<Integer> ports = this.addrs.get(addr.getAddress());
            boolean exactMatch = ports.contains(port);
            boolean genericMatch = ports.contains(0);
            return exactMatch || genericMatch;
        }

        boolean isEmpty() {
            return this.addrs.isEmpty();
        }

        int size() {
            return this.addrs.size();
        }

        void add(InetSocketAddress addr) {
            Preconditions.checkArgument(!addr.isUnresolved());
            this.addrs.put(addr.getAddress(), addr.getPort());
        }

        @Override
        public Iterator<InetSocketAddress> iterator() {
            return new UnmodifiableIterator<InetSocketAddress>(){
                private final Iterator<Map.Entry<InetAddress, Integer>> it;
                {
                    this.it = HostSet.this.addrs.entries().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public InetSocketAddress next() {
                    Map.Entry<InetAddress, Integer> e = this.it.next();
                    return new InetSocketAddress(e.getKey(), (int)e.getValue());
                }
            };
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("HostSet(");
            Joiner.on(",").appendTo(sb, Iterators.transform(this.iterator(), new Function<InetSocketAddress, String>(){

                @Override
                public String apply(@Nullable InetSocketAddress addr) {
                    assert (addr != null);
                    return addr.getAddress().getHostAddress() + ":" + addr.getPort();
                }
            }));
            return sb.append(")").toString();
        }
    }
}

