/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.IOException;
import java.util.SortedSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.UpgradeObjectCollection;
import org.apache.hadoop.hdfs.server.common.Upgradeable;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;

@InterfaceAudience.Private
public abstract class UpgradeManager {
    protected SortedSet<Upgradeable> currentUpgrades = null;
    protected boolean upgradeState = false;
    protected int upgradeVersion = 0;
    protected UpgradeCommand broadcastCommand = null;

    public synchronized UpgradeCommand getBroadcastCommand() {
        return this.broadcastCommand;
    }

    public synchronized boolean getUpgradeState() {
        return this.upgradeState;
    }

    public synchronized int getUpgradeVersion() {
        return this.upgradeVersion;
    }

    public synchronized void setUpgradeState(boolean uState, int uVersion) {
        this.upgradeState = uState;
        this.upgradeVersion = uVersion;
    }

    public SortedSet<Upgradeable> getDistributedUpgrades() throws IOException {
        return UpgradeObjectCollection.getDistributedUpgrades(this.getUpgradeVersion(), this.getType());
    }

    public synchronized short getUpgradeStatus() {
        if (this.currentUpgrades == null) {
            return 100;
        }
        return this.currentUpgrades.first().getUpgradeStatus();
    }

    public synchronized boolean initializeUpgrade() throws IOException {
        this.currentUpgrades = this.getDistributedUpgrades();
        if (this.currentUpgrades == null) {
            this.setUpgradeState(false, HdfsConstants.LAYOUT_VERSION);
            return false;
        }
        Upgradeable curUO = this.currentUpgrades.first();
        this.setUpgradeState(true, curUO.getVersion());
        return true;
    }

    public synchronized boolean isUpgradeCompleted() {
        return this.currentUpgrades == null;
    }

    public abstract HdfsServerConstants.NodeType getType();

    public abstract boolean startUpgrade() throws IOException;

    public abstract void completeUpgrade() throws IOException;
}

