/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.UpgradeObject;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.UpgradeManagerDatanode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;

@InterfaceAudience.Private
public abstract class UpgradeObjectDatanode
extends UpgradeObject
implements Runnable {
    private DataNode dataNode = null;
    private String bpid = null;

    @Override
    public HdfsServerConstants.NodeType getType() {
        return HdfsServerConstants.NodeType.DATA_NODE;
    }

    protected DataNode getDatanode() {
        return this.dataNode;
    }

    protected DatanodeProtocol getNamenode() throws IOException {
        return this.dataNode.getActiveNamenodeForBP(this.bpid);
    }

    void setDatanode(DataNode dataNode, String bpid) {
        this.dataNode = dataNode;
        this.bpid = bpid;
    }

    public abstract void doUpgrade() throws IOException;

    boolean preUpgradeAction(NamespaceInfo nsInfo) throws IOException {
        int nsUpgradeVersion = nsInfo.getDistributedUpgradeVersion();
        if (nsUpgradeVersion >= this.getVersion()) {
            return false;
        }
        String errorMsg = "\n   Data-node missed a distributed upgrade and will shutdown.\n   " + this.getDescription() + "." + " Name-node version = " + nsInfo.getLayoutVersion() + ".";
        DataNode.LOG.fatal(errorMsg);
        String bpid = nsInfo.getBlockPoolID();
        this.dataNode.trySendErrorReport(bpid, 0, errorMsg);
        throw new IOException(errorMsg);
    }

    @Override
    public void run() {
        assert (this.dataNode != null) : "UpgradeObjectDatanode.dataNode is null";
        if (this.dataNode.shouldRun) {
            try {
                this.doUpgrade();
            }
            catch (Exception e) {
                DataNode.LOG.error("Exception in doUpgrade", e);
            }
        }
        if (this.getUpgradeStatus() < 100) {
            DataNode.LOG.info("\n   Distributed upgrade for DataNode version " + this.getVersion() + " to current LV " + HdfsConstants.LAYOUT_VERSION + " cannot be completed.");
        }
        try {
            UpgradeManagerDatanode upgradeManager = this.dataNode.getUpgradeManagerDatanode(this.bpid);
            if (upgradeManager != null) {
                upgradeManager.completeUpgrade();
            }
        }
        catch (IOException e) {
            DataNode.LOG.error("Exception in completeUpgrade", e);
        }
    }

    @Override
    public UpgradeCommand completeUpgrade() throws IOException {
        return new UpgradeCommand(100, this.getVersion(), 100);
    }
}

