/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import java.net.InetSocketAddress;
import org.apache.hadoop.hdfs.web.resources.Param;

abstract class InetSocketAddressParam
extends Param<InetSocketAddress, Domain> {
    InetSocketAddressParam(Domain domain, InetSocketAddress value) {
        super(domain, value);
    }

    @Override
    public String toString() {
        return this.getName() + "=" + Domain.toString((InetSocketAddress)this.getValue());
    }

    static final class Domain
    extends Param.Domain<InetSocketAddress> {
        Domain(String paramName) {
            super(paramName);
        }

        @Override
        public String getDomain() {
            return "<HOST:PORT>";
        }

        @Override
        InetSocketAddress parse(String str) {
            int port;
            if (str == null) {
                throw new IllegalArgumentException("The input string is null: expect " + this.getDomain());
            }
            int i = str.indexOf(58);
            if (i < 0) {
                throw new IllegalArgumentException("Failed to parse \"" + str + "\" as " + this.getDomain() + ": the ':' character not found.");
            }
            if (i == 0) {
                throw new IllegalArgumentException("Failed to parse \"" + str + "\" as " + this.getDomain() + ": HOST is empty.");
            }
            if (i == str.length() - 1) {
                throw new IllegalArgumentException("Failed to parse \"" + str + "\" as " + this.getDomain() + ": PORT is empty.");
            }
            String host = str.substring(0, i);
            try {
                port = Integer.parseInt(str.substring(i + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse \"" + str + "\" as " + this.getDomain() + ": the ':' position is " + i + " but failed to parse PORT.", e);
            }
            try {
                return new InetSocketAddress(host, port);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse \"" + str + "\": cannot create InetSocketAddress(host=" + host + ", port=" + port + ")", e);
            }
        }

        static String toString(InetSocketAddress addr) {
            return addr.getHostName() + ":" + addr.getPort();
        }
    }
}

