/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapreduce.QueueState;
import org.apache.hadoop.security.authorize.AccessControlList;

class Queue
implements Comparable<Queue> {
    private static final Log LOG = LogFactory.getLog(Queue.class);
    private String name = null;
    private Map<String, AccessControlList> acls;
    private QueueState state = QueueState.RUNNING;
    private Object schedulingInfo;
    private Set<Queue> children;
    private Properties props;

    Queue() {
    }

    Queue(String name, Map<String, AccessControlList> acls, QueueState state) {
        this.name = name;
        this.acls = acls;
        this.state = state;
    }

    String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    Map<String, AccessControlList> getAcls() {
        return this.acls;
    }

    void setAcls(Map<String, AccessControlList> acls) {
        this.acls = acls;
    }

    QueueState getState() {
        return this.state;
    }

    void setState(QueueState state) {
        this.state = state;
    }

    Object getSchedulingInfo() {
        return this.schedulingInfo;
    }

    void setSchedulingInfo(Object schedulingInfo) {
        this.schedulingInfo = schedulingInfo;
    }

    void copySchedulingInfo(Queue sourceQueue) {
        Set<Queue> destChildren = this.getChildren();
        if (destChildren != null) {
            Iterator<Queue> itr1 = destChildren.iterator();
            Iterator<Queue> itr2 = sourceQueue.getChildren().iterator();
            while (itr1.hasNext()) {
                itr1.next().copySchedulingInfo(itr2.next());
            }
        }
        this.setSchedulingInfo(sourceQueue.getSchedulingInfo());
    }

    void addChild(Queue child) {
        if (this.children == null) {
            this.children = new TreeSet<Queue>();
        }
        this.children.add(child);
    }

    Set<Queue> getChildren() {
        return this.children;
    }

    void setProperties(Properties props) {
        this.props = props;
    }

    Properties getProperties() {
        return this.props;
    }

    Map<String, Queue> getInnerQueues() {
        HashMap<String, Queue> l = new HashMap<String, Queue>();
        if (this.children == null) {
            return l;
        }
        for (Queue child : this.children) {
            if (child.getChildren() == null || child.getChildren().size() <= 0) continue;
            l.put(child.getName(), child);
            l.putAll(child.getInnerQueues());
        }
        return l;
    }

    Map<String, Queue> getLeafQueues() {
        HashMap<String, Queue> l = new HashMap<String, Queue>();
        if (this.children == null) {
            l.put(this.name, this);
            return l;
        }
        for (Queue child : this.children) {
            l.putAll(child.getLeafQueues());
        }
        return l;
    }

    @Override
    public int compareTo(Queue queue) {
        return this.name.compareTo(queue.getName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Queue)) {
            return false;
        }
        return ((Queue)o).getName().equals(this.name);
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    JobQueueInfo getJobQueueInfo() {
        JobQueueInfo queueInfo = new JobQueueInfo();
        queueInfo.setQueueName(this.name);
        LOG.debug("created jobQInfo " + queueInfo.getQueueName());
        queueInfo.setQueueState(this.state.getStateName());
        if (this.schedulingInfo != null) {
            queueInfo.setSchedulingInfo(this.schedulingInfo.toString());
        }
        if (this.props != null) {
            Properties newProps = new Properties();
            for (Object key : this.props.keySet()) {
                newProps.setProperty(key.toString(), this.props.getProperty(key.toString()));
            }
            queueInfo.setProperties(newProps);
        }
        if (this.children != null && this.children.size() > 0) {
            ArrayList<JobQueueInfo> list = new ArrayList<JobQueueInfo>();
            for (Queue child : this.children) {
                list.add(child.getJobQueueInfo());
            }
            queueInfo.setChildren(list);
        }
        return queueInfo;
    }

    boolean isHierarchySameAs(Queue newState) {
        if (newState == null) {
            return false;
        }
        if (!this.name.equals(newState.getName())) {
            LOG.info(" current name " + this.name + " not equal to " + newState.getName());
            return false;
        }
        if (this.children == null || this.children.size() == 0) {
            if (newState.getChildren() != null && newState.getChildren().size() > 0) {
                LOG.info(newState + " has added children in refresh ");
                return false;
            }
        } else if (this.children.size() > 0) {
            int newChildrenSize;
            if (newState.getChildren() == null) {
                LOG.fatal("In the current state, queue " + this.getName() + " has " + this.children.size() + " but the new state has none!");
                return false;
            }
            int childrenSize = this.children.size();
            if (childrenSize != (newChildrenSize = newState.getChildren().size())) {
                LOG.fatal("Number of children for queue " + newState.getName() + " in newState is " + newChildrenSize + " which is not equal to " + childrenSize + " in the current state.");
                return false;
            }
            Iterator<Queue> itr1 = this.children.iterator();
            Iterator<Queue> itr2 = newState.getChildren().iterator();
            while (itr1.hasNext()) {
                Queue newq;
                Queue q = itr1.next();
                if (q.isHierarchySameAs(newq = itr2.next())) continue;
                LOG.info(" Queue " + q.getName() + " not equal to " + newq.getName());
                return false;
            }
        }
        return true;
    }
}

