/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import com.facebook.presto.hadoop.shaded.org.apache.avro.util.Utf8;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmitted;
import org.apache.hadoop.security.authorize.AccessControlList;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobSubmittedEvent
implements HistoryEvent {
    private JobSubmitted datum = new JobSubmitted();

    public JobSubmittedEvent(JobID id, String jobName, String userName, long submitTime, String jobConfPath, Map<JobACL, AccessControlList> jobACLs, String jobQueueName) {
        this.datum.jobid = new Utf8(id.toString());
        this.datum.jobName = new Utf8(jobName);
        this.datum.userName = new Utf8(userName);
        this.datum.submitTime = submitTime;
        this.datum.jobConfPath = new Utf8(jobConfPath);
        HashMap<CharSequence, CharSequence> jobAcls = new HashMap<CharSequence, CharSequence>();
        for (Map.Entry<JobACL, AccessControlList> entry : jobACLs.entrySet()) {
            jobAcls.put(new Utf8(entry.getKey().getAclName()), new Utf8(entry.getValue().getAclString()));
        }
        this.datum.acls = jobAcls;
        if (jobQueueName != null) {
            this.datum.jobQueueName = new Utf8(jobQueueName);
        }
    }

    JobSubmittedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobSubmitted)datum;
    }

    public JobID getJobId() {
        return JobID.forName(((Object)this.datum.jobid).toString());
    }

    public String getJobName() {
        return ((Object)this.datum.jobName).toString();
    }

    public String getJobQueueName() {
        if (this.datum.jobQueueName != null) {
            return ((Object)this.datum.jobQueueName).toString();
        }
        return null;
    }

    public String getUserName() {
        return ((Object)this.datum.userName).toString();
    }

    public long getSubmitTime() {
        return this.datum.submitTime;
    }

    public String getJobConfPath() {
        return ((Object)this.datum.jobConfPath).toString();
    }

    public Map<JobACL, AccessControlList> getJobAcls() {
        HashMap<JobACL, AccessControlList> jobAcls = new HashMap<JobACL, AccessControlList>();
        for (JobACL jobACL : JobACL.values()) {
            Utf8 jobACLsUtf8 = new Utf8(jobACL.getAclName());
            if (!this.datum.acls.containsKey(jobACLsUtf8)) continue;
            jobAcls.put(jobACL, new AccessControlList(((Object)this.datum.acls.get(jobACLsUtf8)).toString()));
        }
        return jobAcls;
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_SUBMITTED;
    }
}

