/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.security.TokenCache;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class FileOutputFormat<K, V>
extends OutputFormat<K, V> {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    protected static final String BASE_OUTPUT_NAME = "mapreduce.output.basename";
    protected static final String PART = "part";
    private FileOutputCommitter committer = null;
    public static final String COMPRESS = "mapreduce.output.fileoutputformat.compress";
    public static final String COMPRESS_CODEC = "mapreduce.output.fileoutputformat.compress.codec";
    public static final String COMPRESS_TYPE = "mapreduce.output.fileoutputformat.compress.type";
    public static final String OUTDIR = "mapreduce.output.fileoutputformat.outputdir";

    public static void setCompressOutput(Job job, boolean compress) {
        job.getConfiguration().setBoolean(COMPRESS, compress);
    }

    public static boolean getCompressOutput(JobContext job) {
        return job.getConfiguration().getBoolean(COMPRESS, false);
    }

    public static void setOutputCompressorClass(Job job, Class<? extends CompressionCodec> codecClass) {
        FileOutputFormat.setCompressOutput(job, true);
        job.getConfiguration().setClass(COMPRESS_CODEC, codecClass, CompressionCodec.class);
    }

    public static Class<? extends CompressionCodec> getOutputCompressorClass(JobContext job, Class<? extends CompressionCodec> defaultValue) {
        Class<? extends CompressionCodec> codecClass = defaultValue;
        Configuration conf = job.getConfiguration();
        String name = conf.get(COMPRESS_CODEC);
        if (name != null) {
            try {
                codecClass = conf.getClassByName(name).asSubclass(CompressionCodec.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
            }
        }
        return codecClass;
    }

    @Override
    public abstract RecordWriter<K, V> getRecordWriter(TaskAttemptContext var1) throws IOException, InterruptedException;

    @Override
    public void checkOutputSpecs(JobContext job) throws FileAlreadyExistsException, IOException {
        Path outDir = FileOutputFormat.getOutputPath(job);
        if (outDir == null) {
            throw new InvalidJobConfException("Output directory not set.");
        }
        TokenCache.obtainTokensForNamenodes(job.getCredentials(), new Path[]{outDir}, job.getConfiguration());
        if (outDir.getFileSystem(job.getConfiguration()).exists(outDir)) {
            throw new FileAlreadyExistsException("Output directory " + outDir + " already exists");
        }
    }

    public static void setOutputPath(Job job, Path outputDir) {
        try {
            outputDir = outputDir.getFileSystem(job.getConfiguration()).makeQualified(outputDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        job.getConfiguration().set(OUTDIR, outputDir.toString());
    }

    public static Path getOutputPath(JobContext job) {
        String name = job.getConfiguration().get(OUTDIR);
        return name == null ? null : new Path(name);
    }

    public static Path getWorkOutputPath(TaskInputOutputContext<?, ?, ?, ?> context) throws IOException, InterruptedException {
        FileOutputCommitter committer = (FileOutputCommitter)context.getOutputCommitter();
        return committer.getWorkPath();
    }

    public static Path getPathForWorkFile(TaskInputOutputContext<?, ?, ?, ?> context, String name, String extension) throws IOException, InterruptedException {
        return new Path(FileOutputFormat.getWorkOutputPath(context), FileOutputFormat.getUniqueFile(context, name, extension));
    }

    public static synchronized String getUniqueFile(TaskAttemptContext context, String name, String extension) {
        TaskID taskId = context.getTaskAttemptID().getTaskID();
        int partition = taskId.getId();
        StringBuilder result = new StringBuilder();
        result.append(name);
        result.append('-');
        result.append(TaskID.getRepresentingCharacter(taskId.getTaskType()));
        result.append('-');
        result.append(NUMBER_FORMAT.format(partition));
        result.append(extension);
        return result.toString();
    }

    public Path getDefaultWorkFile(TaskAttemptContext context, String extension) throws IOException {
        FileOutputCommitter committer = (FileOutputCommitter)this.getOutputCommitter(context);
        return new Path(committer.getWorkPath(), FileOutputFormat.getUniqueFile(context, FileOutputFormat.getOutputName(context), extension));
    }

    protected static String getOutputName(JobContext job) {
        return job.getConfiguration().get(BASE_OUTPUT_NAME, PART);
    }

    protected static void setOutputName(JobContext job, String name) {
        job.getConfiguration().set(BASE_OUTPUT_NAME, name);
    }

    @Override
    public synchronized OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
        if (this.committer == null) {
            Path output = FileOutputFormat.getOutputPath(context);
            this.committer = new FileOutputCommitter(output, context);
        }
        return this.committer;
    }

    static {
        NUMBER_FORMAT.setMinimumIntegerDigits(5);
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

