/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.MapHost;
import org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MergeManagerImpl;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class OnDiskMapOutput<K, V>
extends MapOutput<K, V> {
    private static final Log LOG = LogFactory.getLog(OnDiskMapOutput.class);
    private final FileSystem localFS;
    private final Path tmpOutputPath;
    private final Path outputPath;
    private final MergeManagerImpl<K, V> merger;
    private final OutputStream disk;

    public OnDiskMapOutput(TaskAttemptID mapId, TaskAttemptID reduceId, MergeManagerImpl<K, V> merger, long size, JobConf conf, MapOutputFile mapOutputFile, int fetcher, boolean primaryMapOutput) throws IOException {
        super(mapId, size, primaryMapOutput);
        this.merger = merger;
        this.localFS = FileSystem.getLocal(conf);
        this.outputPath = mapOutputFile.getInputFileForWrite(mapId.getTaskID(), size);
        this.tmpOutputPath = this.outputPath.suffix(String.valueOf(fetcher));
        this.disk = this.localFS.create(this.tmpOutputPath);
    }

    @Override
    public void shuffle(MapHost host, InputStream input, long compressedLength, long decompressedLength, ShuffleClientMetrics metrics, Reporter reporter) throws IOException {
        long bytesLeft;
        try {
            int n;
            int BYTES_TO_READ = 65536;
            byte[] buf = new byte[65536];
            for (bytesLeft = compressedLength; bytesLeft > 0L; bytesLeft -= (long)n) {
                n = input.read(buf, 0, (int)Math.min(bytesLeft, 65536L));
                if (n < 0) {
                    throw new IOException("read past end of stream reading " + this.getMapId());
                }
                this.disk.write(buf, 0, n);
                metrics.inputBytes(n);
                reporter.progress();
            }
            LOG.info("Read " + (compressedLength - bytesLeft) + " bytes from map-output for " + this.getMapId());
            this.disk.close();
        }
        catch (IOException ioe) {
            IOUtils.cleanup(LOG, input, this.disk);
            throw ioe;
        }
        if (bytesLeft != 0L) {
            throw new IOException("Incomplete map output received for " + this.getMapId() + " from " + host.getHostName() + " (" + bytesLeft + " bytes missing of " + compressedLength + ")");
        }
    }

    @Override
    public void commit() throws IOException {
        this.localFS.rename(this.tmpOutputPath, this.outputPath);
        MergeManagerImpl.CompressAwarePath compressAwarePath = new MergeManagerImpl.CompressAwarePath(this.outputPath, this.getSize());
        this.merger.closeOnDiskFile(compressAwarePath);
    }

    @Override
    public void abort() {
        try {
            this.localFS.delete(this.tmpOutputPath, false);
        }
        catch (IOException ie) {
            LOG.info("failure to clean up " + this.tmpOutputPath, ie);
        }
    }

    @Override
    public String getDescription() {
        return "DISK";
    }
}

