/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.ShuffleConsumerPlugin;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.EventFetcher;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.Fetcher;
import org.apache.hadoop.mapreduce.task.reduce.MergeManager;
import org.apache.hadoop.mapreduce.task.reduce.MergeManagerImpl;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleScheduler;
import org.apache.hadoop.util.Progress;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public class Shuffle<K, V>
implements ShuffleConsumerPlugin<K, V>,
ExceptionReporter {
    private static final int PROGRESS_FREQUENCY = 2000;
    private static final int MAX_EVENTS_TO_FETCH = 10000;
    private static final int MIN_EVENTS_TO_FETCH = 100;
    private static final int MAX_RPC_OUTSTANDING_EVENTS = 3000000;
    private ShuffleConsumerPlugin.Context context;
    private TaskAttemptID reduceId;
    private JobConf jobConf;
    private Reporter reporter;
    private ShuffleClientMetrics metrics;
    private TaskUmbilicalProtocol umbilical;
    private ShuffleScheduler<K, V> scheduler;
    private MergeManager<K, V> merger;
    private Throwable throwable = null;
    private String throwingThreadName = null;
    private Progress copyPhase;
    private TaskStatus taskStatus;
    private Task reduceTask;

    @Override
    public void init(ShuffleConsumerPlugin.Context context) {
        this.context = context;
        this.reduceId = context.getReduceId();
        this.jobConf = context.getJobConf();
        this.umbilical = context.getUmbilical();
        this.reporter = context.getReporter();
        this.metrics = new ShuffleClientMetrics(this.reduceId, this.jobConf);
        this.copyPhase = context.getCopyPhase();
        this.taskStatus = context.getStatus();
        this.reduceTask = context.getReduceTask();
        this.scheduler = new ShuffleScheduler(this.jobConf, this.taskStatus, this, this.copyPhase, context.getShuffledMapsCounter(), context.getReduceShuffleBytes(), context.getFailedShuffleCounter());
        this.merger = this.createMergeManager(context);
    }

    protected MergeManager<K, V> createMergeManager(ShuffleConsumerPlugin.Context context) {
        return new MergeManagerImpl(this.reduceId, this.jobConf, context.getLocalFS(), context.getLocalDirAllocator(), this.reporter, context.getCodec(), context.getCombinerClass(), context.getCombineCollector(), context.getSpilledRecordsCounter(), context.getReduceCombineInputCounter(), context.getMergedMapOutputsCounter(), this, context.getMergePhase(), context.getMapOutputFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawKeyValueIterator run() throws IOException, InterruptedException {
        int eventsPerReducer = Math.max(100, 3000000 / this.jobConf.getNumReduceTasks());
        int maxEventsToFetch = Math.min(10000, eventsPerReducer);
        EventFetcher<K, V> eventFetcher = new EventFetcher<K, V>(this.reduceId, this.umbilical, this.scheduler, this, maxEventsToFetch);
        eventFetcher.start();
        int numFetchers = this.jobConf.getInt("mapreduce.reduce.shuffle.parallelcopies", 5);
        Fetcher[] fetchers = new Fetcher[numFetchers];
        for (int i = 0; i < numFetchers; ++i) {
            fetchers[i] = new Fetcher<K, V>(this.jobConf, this.reduceId, this.scheduler, this.merger, this.reporter, this.metrics, this, this.reduceTask.getJobTokenSecret());
            fetchers[i].start();
        }
        while (!this.scheduler.waitUntilDone(2000)) {
            this.reporter.progress();
            Shuffle i = this;
            synchronized (i) {
                if (this.throwable != null) {
                    throw new ShuffleError("error in shuffle in " + this.throwingThreadName, this.throwable);
                }
            }
        }
        eventFetcher.shutDown();
        for (Fetcher fetcher : fetchers) {
            fetcher.shutDown();
        }
        this.scheduler.close();
        this.copyPhase.complete();
        this.taskStatus.setPhase(TaskStatus.Phase.SORT);
        this.reduceTask.statusUpdate(this.umbilical);
        RawKeyValueIterator kvIter = null;
        try {
            kvIter = this.merger.close();
        }
        catch (Throwable e) {
            throw new ShuffleError("Error while doing final merge ", e);
        }
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if (this.throwable != null) {
                throw new ShuffleError("error in shuffle in " + this.throwingThreadName, this.throwable);
            }
        }
        return kvIter;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reportException(Throwable t) {
        if (this.throwable == null) {
            this.throwable = t;
            this.throwingThreadName = Thread.currentThread().getName();
            ShuffleScheduler<K, V> shuffleScheduler = this.scheduler;
            synchronized (shuffleScheduler) {
                this.scheduler.notifyAll();
            }
        }
    }

    public static class ShuffleError
    extends IOException {
        private static final long serialVersionUID = 5753909320586607881L;

        ShuffleError(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

