/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.source;

import com.facebook.presto.hadoop.shaded.com.google.common.collect.Maps;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.log.metrics.EventCounter;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.source.JvmMetricsInfo;

@InterfaceAudience.Private
public class JvmMetrics
implements MetricsSource {
    static final float M = 1048576.0f;
    final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    final List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    final String processName;
    final String sessionId;
    final Map<String, MetricsInfo[]> gcInfoCache = Maps.newHashMap();

    JvmMetrics(String processName, String sessionId) {
        this.processName = processName;
        this.sessionId = sessionId;
    }

    public static JvmMetrics create(String processName, String sessionId, MetricsSystem ms) {
        return ms.register(JvmMetricsInfo.JvmMetrics.name(), JvmMetricsInfo.JvmMetrics.description(), new JvmMetrics(processName, sessionId));
    }

    public static JvmMetrics initSingleton(String processName, String sessionId) {
        return Singleton.INSTANCE.init(processName, sessionId);
    }

    @Override
    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder rb = collector.addRecord(JvmMetricsInfo.JvmMetrics).setContext("jvm").tag(MsInfo.ProcessName, this.processName).tag(MsInfo.SessionId, this.sessionId);
        this.getMemoryUsage(rb);
        this.getGcUsage(rb);
        this.getThreadUsage(rb);
        this.getEventCounters(rb);
    }

    private void getMemoryUsage(MetricsRecordBuilder rb) {
        MemoryUsage memNonHeap = this.memoryMXBean.getNonHeapMemoryUsage();
        MemoryUsage memHeap = this.memoryMXBean.getHeapMemoryUsage();
        rb.addGauge((MetricsInfo)JvmMetricsInfo.MemNonHeapUsedM, (float)memNonHeap.getUsed() / 1048576.0f).addGauge((MetricsInfo)JvmMetricsInfo.MemNonHeapCommittedM, (float)memNonHeap.getCommitted() / 1048576.0f).addGauge((MetricsInfo)JvmMetricsInfo.MemHeapUsedM, (float)memHeap.getUsed() / 1048576.0f).addGauge((MetricsInfo)JvmMetricsInfo.MemHeapCommittedM, (float)memHeap.getCommitted() / 1048576.0f);
    }

    private void getGcUsage(MetricsRecordBuilder rb) {
        long count = 0L;
        long timeMillis = 0L;
        for (GarbageCollectorMXBean gcBean : this.gcBeans) {
            long c = gcBean.getCollectionCount();
            long t = gcBean.getCollectionTime();
            MetricsInfo[] gcInfo = this.getGcInfo(gcBean.getName());
            rb.addCounter(gcInfo[0], c).addCounter(gcInfo[1], t);
            count += c;
            timeMillis += t;
        }
        rb.addCounter((MetricsInfo)JvmMetricsInfo.GcCount, count).addCounter((MetricsInfo)JvmMetricsInfo.GcTimeMillis, timeMillis);
    }

    private synchronized MetricsInfo[] getGcInfo(String gcName) {
        MetricsInfo[] gcInfo = this.gcInfoCache.get(gcName);
        if (gcInfo == null) {
            gcInfo = new MetricsInfo[]{Interns.info("GcCount" + gcName, "GC Count for " + gcName), Interns.info("GcTimeMillis" + gcName, "GC Time for " + gcName)};
            this.gcInfoCache.put(gcName, gcInfo);
        }
        return gcInfo;
    }

    private void getThreadUsage(MetricsRecordBuilder rb) {
        int threadsNew = 0;
        int threadsRunnable = 0;
        int threadsBlocked = 0;
        int threadsWaiting = 0;
        int threadsTimedWaiting = 0;
        int threadsTerminated = 0;
        long[] threadIds = this.threadMXBean.getAllThreadIds();
        block8: for (ThreadInfo threadInfo : this.threadMXBean.getThreadInfo(threadIds, 0)) {
            if (threadInfo == null) continue;
            switch (threadInfo.getThreadState()) {
                case NEW: {
                    ++threadsNew;
                    continue block8;
                }
                case RUNNABLE: {
                    ++threadsRunnable;
                    continue block8;
                }
                case BLOCKED: {
                    ++threadsBlocked;
                    continue block8;
                }
                case WAITING: {
                    ++threadsWaiting;
                    continue block8;
                }
                case TIMED_WAITING: {
                    ++threadsTimedWaiting;
                    continue block8;
                }
                case TERMINATED: {
                    ++threadsTerminated;
                }
            }
        }
        rb.addGauge((MetricsInfo)JvmMetricsInfo.ThreadsNew, threadsNew).addGauge((MetricsInfo)JvmMetricsInfo.ThreadsRunnable, threadsRunnable).addGauge((MetricsInfo)JvmMetricsInfo.ThreadsBlocked, threadsBlocked).addGauge((MetricsInfo)JvmMetricsInfo.ThreadsWaiting, threadsWaiting).addGauge((MetricsInfo)JvmMetricsInfo.ThreadsTimedWaiting, threadsTimedWaiting).addGauge((MetricsInfo)JvmMetricsInfo.ThreadsTerminated, threadsTerminated);
    }

    private void getEventCounters(MetricsRecordBuilder rb) {
        rb.addCounter((MetricsInfo)JvmMetricsInfo.LogFatal, EventCounter.getFatal()).addCounter((MetricsInfo)JvmMetricsInfo.LogError, EventCounter.getError()).addCounter((MetricsInfo)JvmMetricsInfo.LogWarn, EventCounter.getWarn()).addCounter((MetricsInfo)JvmMetricsInfo.LogInfo, EventCounter.getInfo());
    }

    static enum Singleton {
        INSTANCE;

        JvmMetrics impl;

        synchronized JvmMetrics init(String processName, String sessionId) {
            if (this.impl == null) {
                this.impl = JvmMetrics.create(processName, sessionId, DefaultMetricsSystem.instance());
            }
            return this.impl;
        }
    }
}

