/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.source;

import com.facebook.presto.hadoop.shaded.com.google.common.base.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsInfo;

@InterfaceAudience.Private
public enum JvmMetricsInfo implements MetricsInfo
{
    JvmMetrics("JVM related metrics etc."),
    MemNonHeapUsedM("Non-heap memory used in MB"),
    MemNonHeapCommittedM("Non-heap memory committed in MB"),
    MemHeapUsedM("Heap memory used in MB"),
    MemHeapCommittedM("Heap memory committed in MB"),
    GcCount("Total GC count"),
    GcTimeMillis("Total GC time in milliseconds"),
    ThreadsNew("Number of new threads"),
    ThreadsRunnable("Number of runnable threads"),
    ThreadsBlocked("Number of blocked threads"),
    ThreadsWaiting("Number of waiting threads"),
    ThreadsTimedWaiting("Number of timed waiting threads"),
    ThreadsTerminated("Number of terminated threads"),
    LogFatal("Total number of fatal log events"),
    LogError("Total number of error log events"),
    LogWarn("Total number of warning log events"),
    LogInfo("Total number of info log events");

    private final String desc;

    private JvmMetricsInfo(String desc) {
        this.desc = desc;
    }

    @Override
    public String description() {
        return this.desc;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("name", this.name()).add("description", this.desc).toString();
    }
}

