/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import com.facebook.presto.hadoop.shaded.org.apache.commons.codec.binary.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.hadoop.security.authentication.util.SignerException;

public class Signer {
    private static final String SIGNATURE = "&s=";
    private byte[] secret;

    public Signer(byte[] secret) {
        if (secret == null) {
            throw new IllegalArgumentException("secret cannot be NULL");
        }
        this.secret = (byte[])secret.clone();
    }

    public String sign(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("NULL or empty string to sign");
        }
        String signature = this.computeSignature(str);
        return str + SIGNATURE + signature;
    }

    public String verifyAndExtract(String signedStr) throws SignerException {
        String rawValue;
        String currentSignature;
        int index = signedStr.lastIndexOf(SIGNATURE);
        if (index == -1) {
            throw new SignerException("Invalid signed text: " + signedStr);
        }
        String originalSignature = signedStr.substring(index + SIGNATURE.length());
        if (!originalSignature.equals(currentSignature = this.computeSignature(rawValue = signedStr.substring(0, index)))) {
            throw new SignerException("Invalid signature");
        }
        return rawValue;
    }

    protected String computeSignature(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(str.getBytes());
            md.update(this.secret);
            byte[] digest = md.digest();
            return new Base64(0).encodeToString(digest);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("It should not happen, " + ex.getMessage(), ex);
        }
    }
}

