/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.primitives.Ints;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EntryWeigher;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.CqlLexer;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.MeasurableForPreparedCache;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.QueryPagers;
import org.apache.cassandra.thrift.ThriftClientState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.SemanticVersion;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProcessor
implements QueryHandler {
    public static final SemanticVersion CQL_VERSION = new SemanticVersion("3.2.0");
    public static final QueryProcessor instance = new QueryProcessor();
    private static final Logger logger = LoggerFactory.getLogger(QueryProcessor.class);
    private static final MemoryMeter meter = new MemoryMeter().withGuessing(MemoryMeter.Guess.FALLBACK_BEST);
    private static final long MAX_CACHE_PREPARED_MEMORY = Runtime.getRuntime().maxMemory() / 256L;
    private static final int MAX_CACHE_PREPARED_COUNT = 10000;
    private static EntryWeigher<MD5Digest, ParsedStatement.Prepared> cqlMemoryUsageWeigher = new EntryWeigher<MD5Digest, ParsedStatement.Prepared>(){

        public int weightOf(MD5Digest key, ParsedStatement.Prepared value) {
            return Ints.checkedCast((long)(QueryProcessor.measure(key) + QueryProcessor.measure(value.statement) + QueryProcessor.measure(value.boundNames)));
        }
    };
    private static EntryWeigher<Integer, CQLStatement> thriftMemoryUsageWeigher = new EntryWeigher<Integer, CQLStatement>(){

        public int weightOf(Integer key, CQLStatement value) {
            return Ints.checkedCast((long)(QueryProcessor.measure(key) + QueryProcessor.measure(value)));
        }
    };
    private static final ConcurrentLinkedHashMap<MD5Digest, ParsedStatement.Prepared> preparedStatements;
    private static final ConcurrentLinkedHashMap<Integer, CQLStatement> thriftPreparedStatements;
    private static final ConcurrentMap<String, ParsedStatement.Prepared> internalStatements;

    private static QueryState internalQueryState() {
        return InternalStateInstance.INSTANCE.queryState;
    }

    private QueryProcessor() {
    }

    @Override
    public ParsedStatement.Prepared getPrepared(MD5Digest id) {
        return (ParsedStatement.Prepared)preparedStatements.get((Object)id);
    }

    @Override
    public CQLStatement getPreparedForThrift(Integer id) {
        return (CQLStatement)thriftPreparedStatements.get((Object)id);
    }

    public static void validateKey(ByteBuffer key) throws InvalidRequestException {
        if (key == null || key.remaining() == 0) {
            throw new InvalidRequestException("Key may not be empty");
        }
        if (key.remaining() > 65535) {
            throw new InvalidRequestException("Key length of " + key.remaining() + " is longer than maximum of " + 65535);
        }
    }

    public static void validateCellNames(Iterable<CellName> cellNames, CellNameType type) throws InvalidRequestException {
        for (CellName name : cellNames) {
            QueryProcessor.validateCellName(name, type);
        }
    }

    public static void validateCellName(CellName name, CellNameType type) throws InvalidRequestException {
        QueryProcessor.validateComposite(name, type);
        if (name.isEmpty()) {
            throw new InvalidRequestException("Invalid empty value for clustering column of COMPACT TABLE");
        }
    }

    public static void validateComposite(Composite name, CType type) throws InvalidRequestException {
        long serializedSize = type.serializer().serializedSize(name, TypeSizes.NATIVE);
        if (serializedSize > 65535L) {
            throw new InvalidRequestException(String.format("The sum of all clustering columns is too long (%s > %s)", serializedSize, 65535));
        }
    }

    public static ResultMessage processStatement(CQLStatement statement, QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        logger.trace("Process {} @CL.{}", (Object)statement, (Object)options.getConsistency());
        ClientState clientState = queryState.getClientState();
        statement.checkAccess(clientState);
        statement.validate(clientState);
        ResultMessage result = statement.execute(queryState, options);
        return result == null ? new ResultMessage.Void() : result;
    }

    public static ResultMessage process(String queryString, ConsistencyLevel cl, QueryState queryState) throws RequestExecutionException, RequestValidationException {
        return instance.process(queryString, queryState, QueryOptions.forInternalCalls(cl, Collections.emptyList()));
    }

    @Override
    public ResultMessage process(String queryString, QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        ParsedStatement.Prepared p = QueryProcessor.getStatement(queryString, queryState.getClientState());
        options.prepare(p.boundNames);
        CQLStatement prepared = p.statement;
        if (prepared.getBoundTerms() != options.getValues().size()) {
            throw new InvalidRequestException("Invalid amount of bind variables");
        }
        return QueryProcessor.processStatement(prepared, queryState, options);
    }

    public static ParsedStatement.Prepared parseStatement(String queryStr, QueryState queryState) throws RequestValidationException {
        return QueryProcessor.getStatement(queryStr, queryState.getClientState());
    }

    public static UntypedResultSet process(String query, ConsistencyLevel cl) throws RequestExecutionException {
        try {
            ResultMessage result = instance.process(query, QueryState.forInternalCalls(), QueryOptions.forInternalCalls(cl, Collections.emptyList()));
            if (result instanceof ResultMessage.Rows) {
                return UntypedResultSet.create(((ResultMessage.Rows)result).result);
            }
            return null;
        }
        catch (RequestValidationException e) {
            throw new RuntimeException(e);
        }
    }

    private static QueryOptions makeInternalOptions(ParsedStatement.Prepared prepared, Object[] values) {
        if (prepared.boundNames.size() != values.length) {
            throw new IllegalArgumentException(String.format("Invalid number of values. Expecting %d but got %d", prepared.boundNames.size(), values.length));
        }
        ArrayList<ByteBuffer> boundValues = new ArrayList<ByteBuffer>(values.length);
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            AbstractType<?> type = prepared.boundNames.get((int)i).type;
            boundValues.add(value instanceof ByteBuffer || value == null ? (ByteBuffer)value : type.decompose(value));
        }
        return QueryOptions.forInternalCalls(boundValues);
    }

    private static ParsedStatement.Prepared prepareInternal(String query) throws RequestValidationException {
        ParsedStatement.Prepared prepared = (ParsedStatement.Prepared)internalStatements.get(query);
        if (prepared != null) {
            return prepared;
        }
        prepared = QueryProcessor.parseStatement(query, QueryProcessor.internalQueryState());
        prepared.statement.validate(QueryProcessor.internalQueryState().getClientState());
        internalStatements.putIfAbsent(query, prepared);
        return prepared;
    }

    public static UntypedResultSet executeInternal(String query, Object ... values) {
        try {
            ParsedStatement.Prepared prepared = QueryProcessor.prepareInternal(query);
            ResultMessage result = prepared.statement.executeInternal(QueryProcessor.internalQueryState(), QueryProcessor.makeInternalOptions(prepared, values));
            if (result instanceof ResultMessage.Rows) {
                return UntypedResultSet.create(((ResultMessage.Rows)result).result);
            }
            return null;
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (RequestValidationException e) {
            throw new RuntimeException("Error validating " + query, e);
        }
    }

    public static UntypedResultSet executeInternalWithPaging(String query, int pageSize, Object ... values) {
        try {
            ParsedStatement.Prepared prepared = QueryProcessor.prepareInternal(query);
            if (!(prepared.statement instanceof SelectStatement)) {
                throw new IllegalArgumentException("Only SELECTs can be paged");
            }
            SelectStatement select = (SelectStatement)prepared.statement;
            QueryPager pager = QueryPagers.localPager(select.getPageableCommand(QueryProcessor.makeInternalOptions(prepared, values)));
            return UntypedResultSet.create(select, pager, pageSize);
        }
        catch (RequestValidationException e) {
            throw new RuntimeException("Error validating query" + e);
        }
    }

    public static UntypedResultSet executeOnceInternal(String query, Object ... values) {
        try {
            ParsedStatement.Prepared prepared = QueryProcessor.parseStatement(query, QueryProcessor.internalQueryState());
            prepared.statement.validate(QueryProcessor.internalQueryState().getClientState());
            ResultMessage result = prepared.statement.executeInternal(QueryProcessor.internalQueryState(), QueryProcessor.makeInternalOptions(prepared, values));
            if (result instanceof ResultMessage.Rows) {
                return UntypedResultSet.create(((ResultMessage.Rows)result).result);
            }
            return null;
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (RequestValidationException e) {
            throw new RuntimeException("Error validating query " + query, e);
        }
    }

    public static UntypedResultSet resultify(String query, Row row) {
        return QueryProcessor.resultify(query, Collections.singletonList(row));
    }

    public static UntypedResultSet resultify(String query, List<Row> rows) {
        try {
            SelectStatement ss = (SelectStatement)QueryProcessor.getStatement((String)query, null).statement;
            ResultSet cqlRows = ss.process(rows);
            return UntypedResultSet.create(cqlRows);
        }
        catch (RequestValidationException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ResultMessage.Prepared prepare(String queryString, QueryState queryState) throws RequestValidationException {
        ClientState cState = queryState.getClientState();
        return QueryProcessor.prepare(queryString, cState, cState instanceof ThriftClientState);
    }

    public static ResultMessage.Prepared prepare(String queryString, ClientState clientState, boolean forThrift) throws RequestValidationException {
        ParsedStatement.Prepared prepared = QueryProcessor.getStatement(queryString, clientState);
        int boundTerms = prepared.statement.getBoundTerms();
        if (boundTerms > 65535) {
            throw new InvalidRequestException(String.format("Too many markers(?). %d markers exceed the allowed maximum of %d", boundTerms, 65535));
        }
        assert (boundTerms == prepared.boundNames.size());
        return QueryProcessor.storePreparedStatement(queryString, clientState.getRawKeyspace(), prepared, forThrift);
    }

    private static ResultMessage.Prepared storePreparedStatement(String queryString, String keyspace, ParsedStatement.Prepared prepared, boolean forThrift) throws InvalidRequestException {
        String toHash = keyspace == null ? queryString : keyspace + queryString;
        long statementSize = QueryProcessor.measure(prepared.statement);
        if (statementSize > MAX_CACHE_PREPARED_MEMORY) {
            throw new InvalidRequestException(String.format("Prepared statement of size %d bytes is larger than allowed maximum of %d bytes.", statementSize, MAX_CACHE_PREPARED_MEMORY));
        }
        if (forThrift) {
            int statementId = toHash.hashCode();
            thriftPreparedStatements.put((Object)statementId, (Object)prepared.statement);
            logger.trace(String.format("Stored prepared statement #%d with %d bind markers", statementId, prepared.statement.getBoundTerms()));
            return ResultMessage.Prepared.forThrift(statementId, prepared.boundNames);
        }
        MD5Digest statementId = MD5Digest.compute(toHash);
        preparedStatements.put((Object)statementId, (Object)prepared);
        logger.trace(String.format("Stored prepared statement %s with %d bind markers", statementId, prepared.statement.getBoundTerms()));
        return new ResultMessage.Prepared(statementId, prepared);
    }

    @Override
    public ResultMessage processPrepared(CQLStatement statement, QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> variables = options.getValues();
        if (!variables.isEmpty() || statement.getBoundTerms() != 0) {
            if (variables.size() != statement.getBoundTerms()) {
                throw new InvalidRequestException(String.format("there were %d markers(?) in CQL but %d bound variables", statement.getBoundTerms(), variables.size()));
            }
            if (logger.isTraceEnabled()) {
                for (int i = 0; i < variables.size(); ++i) {
                    logger.trace("[{}] '{}'", (Object)(i + 1), (Object)variables.get(i));
                }
            }
        }
        return QueryProcessor.processStatement(statement, queryState, options);
    }

    @Override
    public ResultMessage processBatch(BatchStatement batch, QueryState queryState, BatchQueryOptions options) throws RequestExecutionException, RequestValidationException {
        ClientState clientState = queryState.getClientState();
        batch.checkAccess(clientState);
        batch.validate();
        batch.validate(clientState);
        return batch.execute(queryState, options);
    }

    public static ParsedStatement.Prepared getStatement(String queryStr, ClientState clientState) throws RequestValidationException {
        Tracing.trace("Parsing {}", queryStr);
        ParsedStatement statement = QueryProcessor.parseStatement(queryStr);
        if (statement instanceof CFStatement) {
            ((CFStatement)statement).prepareKeyspace(clientState);
        }
        Tracing.trace("Preparing statement");
        return statement.prepare();
    }

    public static ParsedStatement parseStatement(String queryStr) throws SyntaxException {
        try {
            ANTLRStringStream stream = new ANTLRStringStream(queryStr);
            CqlLexer lexer = new CqlLexer((CharStream)stream);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            CqlParser parser = new CqlParser((TokenStream)tokenStream);
            ParsedStatement statement = parser.query();
            lexer.throwLastRecognitionError();
            parser.throwLastRecognitionError();
            return statement;
        }
        catch (RuntimeException re) {
            throw new SyntaxException(String.format("Failed parsing statement: [%s] reason: %s %s", queryStr, re.getClass().getSimpleName(), re.getMessage()));
        }
        catch (RecognitionException e) {
            throw new SyntaxException("Invalid or malformed CQL query string: " + e.getMessage());
        }
    }

    private static long measure(Object key) {
        return key instanceof MeasurableForPreparedCache ? ((MeasurableForPreparedCache)key).measureForPreparedCache(meter) : meter.measureDeep(key);
    }

    static {
        internalStatements = new ConcurrentHashMap<String, ParsedStatement.Prepared>();
        preparedStatements = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(MAX_CACHE_PREPARED_MEMORY).weigher(cqlMemoryUsageWeigher).build();
        thriftPreparedStatements = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(MAX_CACHE_PREPARED_MEMORY).weigher(thriftMemoryUsageWeigher).build();
    }

    private static enum InternalStateInstance {
        INSTANCE;

        private final QueryState queryState;

        private InternalStateInstance() {
            ClientState state = ClientState.forInternalCalls();
            try {
                state.setKeyspace("system");
            }
            catch (InvalidRequestException e) {
                throw new RuntimeException();
            }
            this.queryState = new QueryState(state);
        }
    }
}

