/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.primitives.Ints;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ObjectSizes;

public class RowIndexEntry
implements IMeasurableMemory {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new RowIndexEntry(0L));
    public final long position;

    public RowIndexEntry(long position) {
        this.position = position;
    }

    protected int promotedSize(CType type) {
        return 0;
    }

    public static RowIndexEntry create(long position, DeletionTime deletionTime, ColumnIndex index) {
        assert (index != null);
        assert (deletionTime != null);
        if (index.columnsIndex.size() > 1) {
            return new IndexedEntry(position, deletionTime, index.columnsIndex);
        }
        return new RowIndexEntry(position);
    }

    public boolean isIndexed() {
        return !this.columnsIndex().isEmpty();
    }

    public DeletionTime deletionTime() {
        throw new UnsupportedOperationException();
    }

    public List<IndexHelper.IndexInfo> columnsIndex() {
        return Collections.emptyList();
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE;
    }

    private static class IndexedEntry
    extends RowIndexEntry {
        private final DeletionTime deletionTime;
        private final List<IndexHelper.IndexInfo> columnsIndex;
        private static final long BASE_SIZE = ObjectSizes.measure(new IndexedEntry(0L, DeletionTime.LIVE, Arrays.asList(null, null))) + ObjectSizes.measure(new ArrayList(1));

        private IndexedEntry(long position, DeletionTime deletionTime, List<IndexHelper.IndexInfo> columnsIndex) {
            super(position);
            assert (deletionTime != null);
            assert (columnsIndex != null && columnsIndex.size() > 1);
            this.deletionTime = deletionTime;
            this.columnsIndex = columnsIndex;
        }

        @Override
        public DeletionTime deletionTime() {
            return this.deletionTime;
        }

        @Override
        public List<IndexHelper.IndexInfo> columnsIndex() {
            return this.columnsIndex;
        }

        @Override
        public int promotedSize(CType type) {
            TypeSizes typeSizes = TypeSizes.NATIVE;
            long size = DeletionTime.serializer.serializedSize(this.deletionTime, typeSizes);
            size += (long)typeSizes.sizeof(this.columnsIndex.size());
            ISerializer<IndexHelper.IndexInfo> idxSerializer = type.indexSerializer();
            for (IndexHelper.IndexInfo info : this.columnsIndex) {
                size += idxSerializer.serializedSize(info, typeSizes);
            }
            return Ints.checkedCast((long)size);
        }

        @Override
        public long unsharedHeapSize() {
            long entrySize = 0L;
            for (IndexHelper.IndexInfo idx : this.columnsIndex) {
                entrySize += idx.unsharedHeapSize();
            }
            return BASE_SIZE + entrySize + this.deletionTime.unsharedHeapSize() + ObjectSizes.sizeOfReferenceArray(this.columnsIndex.size());
        }
    }

    public static class Serializer {
        private final CType type;

        public Serializer(CType type) {
            this.type = type;
        }

        public void serialize(RowIndexEntry rie, DataOutputPlus out) throws IOException {
            out.writeLong(rie.position);
            out.writeInt(rie.promotedSize(this.type));
            if (rie.isIndexed()) {
                DeletionTime.serializer.serialize(rie.deletionTime(), out);
                out.writeInt(rie.columnsIndex().size());
                ISerializer<IndexHelper.IndexInfo> idxSerializer = this.type.indexSerializer();
                for (IndexHelper.IndexInfo info : rie.columnsIndex()) {
                    idxSerializer.serialize(info, out);
                }
            }
        }

        public RowIndexEntry deserialize(DataInput in, Descriptor.Version version) throws IOException {
            long position = in.readLong();
            int size = in.readInt();
            if (size > 0) {
                DeletionTime deletionTime = DeletionTime.serializer.deserialize(in);
                int entries = in.readInt();
                ISerializer<IndexHelper.IndexInfo> idxSerializer = this.type.indexSerializer();
                ArrayList<IndexHelper.IndexInfo> columnsIndex = new ArrayList<IndexHelper.IndexInfo>(entries);
                for (int i = 0; i < entries; ++i) {
                    columnsIndex.add(idxSerializer.deserialize(in));
                }
                return new IndexedEntry(position, deletionTime, columnsIndex);
            }
            return new RowIndexEntry(position);
        }

        public static void skip(DataInput in) throws IOException {
            in.readLong();
            Serializer.skipPromotedIndex(in);
        }

        public static void skipPromotedIndex(DataInput in) throws IOException {
            int size = in.readInt();
            if (size <= 0) {
                return;
            }
            FileUtils.skipBytesFully(in, size);
        }

        public int serializedSize(RowIndexEntry rie) {
            return TypeSizes.NATIVE.sizeof(rie.position) + rie.promotedSize(this.type);
        }
    }
}

