/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.DataInput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnCounter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileDataInput;

public interface IDiskAtomFilter {
    public Iterator<Cell> getColumnIterator(ColumnFamily var1);

    public OnDiskAtomIterator getColumnIterator(DecoratedKey var1, ColumnFamily var2);

    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader var1, FileDataInput var2, DecoratedKey var3, RowIndexEntry var4);

    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader var1, DecoratedKey var2);

    public void collectReducedColumns(ColumnFamily var1, Iterator<Cell> var2, int var3, long var4);

    public Comparator<Cell> getColumnComparator(CellNameType var1);

    public boolean isReversed();

    public void updateColumnsLimit(int var1);

    public int getLiveCount(ColumnFamily var1, long var2);

    public ColumnCounter columnCounter(CellNameType var1, long var2);

    public IDiskAtomFilter cloneShallow();

    public boolean maySelectPrefix(CType var1, Composite var2);

    public boolean shouldInclude(SSTableReader var1);

    public boolean countCQL3Rows(CellNameType var1);

    public boolean isHeadFilter();

    public boolean isFullyCoveredBy(ColumnFamily var1, long var2);

    public Iterator<RangeTombstone> getRangeTombstoneIterator(ColumnFamily var1);

    public static class Serializer
    implements IVersionedSerializer<IDiskAtomFilter> {
        private final CellNameType type;

        public Serializer(CellNameType type) {
            this.type = type;
        }

        @Override
        public void serialize(IDiskAtomFilter filter, DataOutputPlus out, int version) throws IOException {
            if (filter instanceof SliceQueryFilter) {
                out.writeByte(0);
                this.type.sliceQueryFilterSerializer().serialize((SliceQueryFilter)filter, out, version);
            } else {
                out.writeByte(1);
                this.type.namesQueryFilterSerializer().serialize((NamesQueryFilter)filter, out, version);
            }
        }

        @Override
        public IDiskAtomFilter deserialize(DataInput in, int version) throws IOException {
            byte b = in.readByte();
            if (b == 0) {
                return this.type.sliceQueryFilterSerializer().deserialize(in, version);
            }
            assert (b == 1);
            return this.type.namesQueryFilterSerializer().deserialize(in, version);
        }

        @Override
        public long serializedSize(IDiskAtomFilter filter, int version) {
            int size = 1;
            size = filter instanceof SliceQueryFilter ? (int)((long)size + this.type.sliceQueryFilterSerializer().serializedSize((SliceQueryFilter)filter, version)) : (int)((long)size + this.type.namesQueryFilterSerializer().serializedSize((NamesQueryFilter)filter, version));
            return size;
        }
    }
}

