/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.serializers.DoubleSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DoubleType
extends AbstractType<Double> {
    public static final DoubleType instance = new DoubleType();

    DoubleType() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        return ((Double)this.compose(o1)).compareTo((Double)this.compose(o2));
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        Double d;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            d = Double.valueOf(source);
        }
        catch (NumberFormatException e1) {
            throw new MarshalException(String.format("unable to coerce '%s' to a double", source), e1);
        }
        return this.decompose(d);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.DOUBLE;
    }

    @Override
    public TypeSerializer<Double> getSerializer() {
        return DoubleSerializer.instance;
    }
}

