/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.pig;

import com.datastax.driver.core.Row;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.composites.CellNames;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.cassandra.hadoop.pig.AbstractCassandraStorage;
import org.apache.cassandra.hadoop.pig.CqlStorage;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class CqlNativeStorage
extends CqlStorage {
    private RecordReader<Long, Row> reader;
    private String nativePort;
    private String nativeCoreConnections;
    private String nativeMaxConnections;
    private String nativeMinSimultReqs;
    private String nativeMaxSimultReqs;
    private String nativeConnectionTimeout;
    private String nativeReadConnectionTimeout;
    private String nativeReceiveBufferSize;
    private String nativeSendBufferSize;
    private String nativeSolinger;
    private String nativeTcpNodelay;
    private String nativeReuseAddress;
    private String nativeKeepAlive;
    private String nativeAuthProvider;
    private String nativeSSLTruststorePath;
    private String nativeSSLKeystorePath;
    private String nativeSSLTruststorePassword;
    private String nativeSSLKeystorePassword;
    private String nativeSSLCipherSuites;
    private String inputCql;

    public CqlNativeStorage() {
        this(1000);
    }

    public CqlNativeStorage(int pageSize) {
        super(pageSize);
        this.DEFAULT_INPUT_FORMAT = "org.apache.cassandra.hadoop.cql3.CqlInputFormat";
    }

    @Override
    public void prepareToRead(RecordReader reader, PigSplit split) {
        this.reader = reader;
    }

    @Override
    public Tuple getNext() throws IOException {
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            AbstractCassandraStorage.CfInfo cfInfo = this.getCfInfo(this.loadSignature);
            CfDef cfDef = cfInfo.cfDef;
            Row row = (Row)this.reader.getCurrentValue();
            Tuple tuple = TupleFactory.getInstance().newTuple(cfDef.column_metadata.size());
            Iterator itera = cfDef.column_metadata.iterator();
            int i = 0;
            while (itera.hasNext()) {
                ColumnDef cdef = (ColumnDef)itera.next();
                ByteBuffer columnValue = row.getBytesUnsafe(ByteBufferUtil.string(cdef.name.duplicate()));
                if (columnValue != null) {
                    BufferCell cell = new BufferCell(CellNames.simpleDense(cdef.name), columnValue);
                    AbstractType validator = this.getValidatorMap(cfDef).get(cdef.name);
                    this.setTupleValue(tuple, i, this.cqlColumnToObj(cell, cfDef), validator);
                } else {
                    tuple.set(i, null);
                }
                ++i;
            }
            return tuple;
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        this.conf = job.getConfiguration();
        this.setLocationFromUri(location);
        if (this.username != null && this.password != null) {
            ConfigHelper.setInputKeyspaceUserNameAndPassword(this.conf, this.username, this.password);
            CqlConfigHelper.setUserNameAndPassword(this.conf, this.username, this.password);
        }
        if (this.splitSize > 0) {
            ConfigHelper.setInputSplitSize(this.conf, this.splitSize);
        }
        if (this.partitionerClass != null) {
            ConfigHelper.setInputPartitioner(this.conf, this.partitionerClass);
        }
        if (this.initHostAddress != null) {
            ConfigHelper.setInputInitialAddress(this.conf, this.initHostAddress);
        }
        if (this.rpcPort != null) {
            ConfigHelper.setInputRpcPort(this.conf, this.rpcPort);
        }
        if (this.nativePort != null) {
            CqlConfigHelper.setInputNativePort(this.conf, this.nativePort);
        }
        if (this.nativeCoreConnections != null) {
            CqlConfigHelper.setInputCoreConnections(this.conf, this.nativeCoreConnections);
        }
        if (this.nativeMaxConnections != null) {
            CqlConfigHelper.setInputMaxConnections(this.conf, this.nativeMaxConnections);
        }
        if (this.nativeMinSimultReqs != null) {
            CqlConfigHelper.setInputMinSimultReqPerConnections(this.conf, this.nativeMinSimultReqs);
        }
        if (this.nativeMaxSimultReqs != null) {
            CqlConfigHelper.setInputMaxSimultReqPerConnections(this.conf, this.nativeMaxSimultReqs);
        }
        if (this.nativeConnectionTimeout != null) {
            CqlConfigHelper.setInputNativeConnectionTimeout(this.conf, this.nativeConnectionTimeout);
        }
        if (this.nativeReadConnectionTimeout != null) {
            CqlConfigHelper.setInputNativeReadConnectionTimeout(this.conf, this.nativeReadConnectionTimeout);
        }
        if (this.nativeReceiveBufferSize != null) {
            CqlConfigHelper.setInputNativeReceiveBufferSize(this.conf, this.nativeReceiveBufferSize);
        }
        if (this.nativeSendBufferSize != null) {
            CqlConfigHelper.setInputNativeSendBufferSize(this.conf, this.nativeSendBufferSize);
        }
        if (this.nativeSolinger != null) {
            CqlConfigHelper.setInputNativeSolinger(this.conf, this.nativeSolinger);
        }
        if (this.nativeTcpNodelay != null) {
            CqlConfigHelper.setInputNativeTcpNodelay(this.conf, this.nativeTcpNodelay);
        }
        if (this.nativeReuseAddress != null) {
            CqlConfigHelper.setInputNativeReuseAddress(this.conf, this.nativeReuseAddress);
        }
        if (this.nativeKeepAlive != null) {
            CqlConfigHelper.setInputNativeKeepAlive(this.conf, this.nativeKeepAlive);
        }
        if (this.nativeAuthProvider != null) {
            CqlConfigHelper.setInputNativeAuthProvider(this.conf, this.nativeAuthProvider);
        }
        if (this.nativeSSLTruststorePath != null) {
            CqlConfigHelper.setInputNativeSSLTruststorePath(this.conf, this.nativeSSLTruststorePath);
        }
        if (this.nativeSSLKeystorePath != null) {
            CqlConfigHelper.setInputNativeSSLKeystorePath(this.conf, this.nativeSSLKeystorePath);
        }
        if (this.nativeSSLTruststorePassword != null) {
            CqlConfigHelper.setInputNativeSSLTruststorePassword(this.conf, this.nativeSSLTruststorePassword);
        }
        if (this.nativeSSLKeystorePassword != null) {
            CqlConfigHelper.setInputNativeSSLKeystorePassword(this.conf, this.nativeSSLKeystorePassword);
        }
        if (this.nativeSSLCipherSuites != null) {
            CqlConfigHelper.setInputNativeSSLCipherSuites(this.conf, this.nativeSSLCipherSuites);
        }
        ConfigHelper.setInputColumnFamily(this.conf, this.keyspace, this.column_family);
        this.setConnectionInformation();
        CqlConfigHelper.setInputCQLPageRowSize(this.conf, String.valueOf(this.pageSize));
        if (this.inputCql != null) {
            CqlConfigHelper.setInputCql(this.conf, this.inputCql);
        }
        if (this.columns != null) {
            CqlConfigHelper.setInputColumns(this.conf, this.columns);
        }
        if (this.whereClause != null) {
            CqlConfigHelper.setInputWhereClauses(this.conf, this.whereClause);
        }
        if (System.getenv("PIG_INPUT_SPLIT_SIZE") != null) {
            try {
                ConfigHelper.setInputSplitSize(this.conf, Integer.parseInt(System.getenv("PIG_INPUT_SPLIT_SIZE")));
            }
            catch (NumberFormatException e) {
                throw new IOException("PIG_INPUT_SPLIT_SIZE is not a number", e);
            }
        }
        if (ConfigHelper.getInputInitialAddress(this.conf) == null) {
            throw new IOException("PIG_INPUT_INITIAL_ADDRESS or PIG_INITIAL_ADDRESS environment variable not set");
        }
        if (ConfigHelper.getInputPartitioner(this.conf) == null) {
            throw new IOException("PIG_INPUT_PARTITIONER or PIG_PARTITIONER environment variable not set");
        }
        if (this.loadSignature == null) {
            this.loadSignature = location;
        }
        this.initSchema(this.loadSignature);
    }

    private void setLocationFromUri(String location) throws IOException {
        try {
            String[] parts;
            String[] credentialsAndKeyspace;
            if (!location.startsWith("cql://")) {
                throw new Exception("Bad scheme: " + location);
            }
            String[] urlParts = location.split("\\?");
            if (urlParts.length > 1) {
                Map<String, String> urlQuery = CqlNativeStorage.getQueryMap(urlParts[1]);
                if (urlQuery.containsKey("page_size")) {
                    this.pageSize = Integer.parseInt(urlQuery.get("page_size"));
                }
                if (urlQuery.containsKey("output_query")) {
                    this.outputQuery = urlQuery.get("output_query");
                }
                if (urlQuery.containsKey("split_size")) {
                    this.splitSize = Integer.parseInt(urlQuery.get("split_size"));
                }
                if (urlQuery.containsKey("partitioner")) {
                    this.partitionerClass = urlQuery.get("partitioner");
                }
                if (urlQuery.containsKey("use_secondary")) {
                    this.usePartitionFilter = Boolean.parseBoolean(urlQuery.get("use_secondary"));
                }
                if (urlQuery.containsKey("init_address")) {
                    this.initHostAddress = urlQuery.get("init_address");
                }
                if (urlQuery.containsKey("native_port")) {
                    this.nativePort = urlQuery.get("native_port");
                }
                if (urlQuery.containsKey("core_conns")) {
                    this.nativeCoreConnections = urlQuery.get("core_conns");
                }
                if (urlQuery.containsKey("max_conns")) {
                    this.nativeMaxConnections = urlQuery.get("max_conns");
                }
                if (urlQuery.containsKey("min_simult_reqs")) {
                    this.nativeMinSimultReqs = urlQuery.get("min_simult_reqs");
                }
                if (urlQuery.containsKey("max_simult_reqs")) {
                    this.nativeMaxSimultReqs = urlQuery.get("max_simult_reqs");
                }
                if (urlQuery.containsKey("native_timeout")) {
                    this.nativeConnectionTimeout = urlQuery.get("native_timeout");
                }
                if (urlQuery.containsKey("native_read_timeout")) {
                    this.nativeReadConnectionTimeout = urlQuery.get("native_read_timeout");
                }
                if (urlQuery.containsKey("rec_buff_size")) {
                    this.nativeReceiveBufferSize = urlQuery.get("rec_buff_size");
                }
                if (urlQuery.containsKey("send_buff_size")) {
                    this.nativeSendBufferSize = urlQuery.get("send_buff_size");
                }
                if (urlQuery.containsKey("solinger")) {
                    this.nativeSolinger = urlQuery.get("solinger");
                }
                if (urlQuery.containsKey("tcp_nodelay")) {
                    this.nativeTcpNodelay = urlQuery.get("tcp_nodelay");
                }
                if (urlQuery.containsKey("reuse_address")) {
                    this.nativeReuseAddress = urlQuery.get("reuse_address");
                }
                if (urlQuery.containsKey("keep_alive")) {
                    this.nativeKeepAlive = urlQuery.get("keep_alive");
                }
                if (urlQuery.containsKey("auth_provider")) {
                    this.nativeAuthProvider = urlQuery.get("auth_provider");
                }
                if (urlQuery.containsKey("trust_store_path")) {
                    this.nativeSSLTruststorePath = urlQuery.get("trust_store_path");
                }
                if (urlQuery.containsKey("key_store_path")) {
                    this.nativeSSLKeystorePath = urlQuery.get("key_store_path");
                }
                if (urlQuery.containsKey("trust_store_password")) {
                    this.nativeSSLTruststorePassword = urlQuery.get("trust_store_password");
                }
                if (urlQuery.containsKey("key_store_password")) {
                    this.nativeSSLKeystorePassword = urlQuery.get("key_store_password");
                }
                if (urlQuery.containsKey("cipher_suites")) {
                    this.nativeSSLCipherSuites = urlQuery.get("cipher_suites");
                }
                if (urlQuery.containsKey("input_cql")) {
                    this.inputCql = urlQuery.get("input_cql");
                }
                if (urlQuery.containsKey("columns")) {
                    this.columns = urlQuery.get("columns");
                }
                if (urlQuery.containsKey("where_clause")) {
                    this.whereClause = urlQuery.get("where_clause");
                }
                if (urlQuery.containsKey("rpc_port")) {
                    this.rpcPort = urlQuery.get("rpc_port");
                }
            }
            if ((credentialsAndKeyspace = (parts = urlParts[0].split("/+"))[1].split("@")).length > 1) {
                String[] credentials = credentialsAndKeyspace[0].split(":");
                this.username = credentials[0];
                this.password = credentials[1];
                this.keyspace = credentialsAndKeyspace[1];
            } else {
                this.keyspace = parts[1];
            }
            this.column_family = parts[2];
        }
        catch (Exception e) {
            throw new IOException("Expected 'cql://[username:password@]<keyspace>/<columnfamily>[?[page_size=<size>][&columns=<col1,col2>][&output_query=<prepared_statement>][&where_clause=<clause>][&split_size=<size>][&partitioner=<partitioner>][&use_secondary=true|false][&init_address=<host>][&native_port=<native_port>][&core_conns=<core_conns>][&max_conns=<max_conns>][&min_simult_reqs=<min_simult_reqs>][&max_simult_reqs=<max_simult_reqs>][&native_timeout=<native_timeout>][&native_read_timeout=<native_read_timeout>][&rec_buff_size=<rec_buff_size>][&send_buff_size=<send_buff_size>][&solinger=<solinger>][&tcp_nodelay=<tcp_nodelay>][&reuse_address=<reuse_address>][&keep_alive=<keep_alive>][&auth_provider=<auth_provider>][&trust_store_path=<trust_store_path>][&key_store_path=<key_store_path>][&trust_store_password=<trust_store_password>][&key_store_password=<key_store_password>][&cipher_suites=<cipher_suites>][&input_cql=<input_cql>][columns=<columns>][where_clause=<where_clause>]]': " + e.getMessage());
        }
    }
}

