/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.sun.management.GarbageCollectionNotificationInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collections;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.cassandra.io.sstable.SSTableDeletingTask;
import org.apache.cassandra.utils.StatusLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCInspector
implements NotificationListener {
    private static final Logger logger = LoggerFactory.getLogger(GCInspector.class);
    static final long MIN_DURATION = 200L;
    static final long MIN_DURATION_TPSTATS = 1000L;

    public static void register() throws Exception {
        GCInspector inspector = new GCInspector();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName gcName = new ObjectName("java.lang:type=GarbageCollector,*");
        for (ObjectName name : server.queryNames(gcName, null)) {
            server.addNotificationListener(name, inspector, null, null);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        if (type.equals("com.sun.management.gc.notification")) {
            CompositeData cd = (CompositeData)notification.getUserData();
            GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from(cd);
            long duration = info.getGcInfo().getDuration();
            StringBuilder sb = new StringBuilder();
            sb.append(info.getGcName()).append(" GC in ").append(duration).append("ms.  ");
            ArrayList<String> keys = new ArrayList<String>(info.getGcInfo().getMemoryUsageBeforeGc().keySet());
            Collections.sort(keys);
            for (String key : keys) {
                MemoryUsage before = info.getGcInfo().getMemoryUsageBeforeGc().get(key);
                MemoryUsage after = info.getGcInfo().getMemoryUsageAfterGc().get(key);
                if (after == null || after.getUsed() == before.getUsed()) continue;
                sb.append(key).append(": ").append(before.getUsed());
                sb.append(" -> ");
                sb.append(after.getUsed());
                if (key.equals(keys.get(keys.size() - 1))) continue;
                sb.append("; ");
            }
            String st = sb.toString();
            if (duration > 200L) {
                logger.info(st);
            } else if (logger.isDebugEnabled()) {
                logger.debug(st);
            }
            if (duration > 1000L) {
                StatusLogger.log();
            }
            if (info.getGcName().equals("ConcurrentMarkSweep")) {
                SSTableDeletingTask.rescheduleFailedTasks();
            }
        }
    }
}

