/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.net.InetAddress;
import java.util.UUID;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.StreamSession;

public abstract class StreamEvent {
    public final Type eventType;
    public final UUID planId;

    protected StreamEvent(Type eventType, UUID planId) {
        this.eventType = eventType;
        this.planId = planId;
    }

    public static class SessionPreparedEvent
    extends StreamEvent {
        public final SessionInfo session;

        public SessionPreparedEvent(UUID planId, SessionInfo session) {
            super(Type.STREAM_PREPARED, planId);
            this.session = session;
        }
    }

    public static class ProgressEvent
    extends StreamEvent {
        public final ProgressInfo progress;

        public ProgressEvent(UUID planId, ProgressInfo progress) {
            super(Type.FILE_PROGRESS, planId);
            this.progress = progress;
        }

        public String toString() {
            return "<ProgressEvent " + this.progress.toString() + ">";
        }
    }

    public static class SessionCompleteEvent
    extends StreamEvent {
        public final InetAddress peer;
        public final boolean success;
        public final int sessionIndex;

        public SessionCompleteEvent(StreamSession session) {
            super(Type.STREAM_COMPLETE, session.planId());
            this.peer = session.peer;
            this.success = session.isSuccess();
            this.sessionIndex = session.sessionIndex();
        }
    }

    public static enum Type {
        STREAM_PREPARED,
        STREAM_COMPLETE,
        FILE_PROGRESS;

    }
}

