/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.primitives.UnsignedBytes;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

class FastByteOperations {
    FastByteOperations() {
    }

    public static int compareUnsigned(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        return BestHolder.BEST.compare(b1, s1, l1, b2, s2, l2);
    }

    public static int compareUnsigned(ByteBuffer b1, byte[] b2, int s2, int l2) {
        return BestHolder.BEST.compare(b1, b2, s2, l2);
    }

    public static int compareUnsigned(byte[] b1, int s1, int l1, ByteBuffer b2) {
        return -BestHolder.BEST.compare(b2, b1, s1, l1);
    }

    public static int compareUnsigned(ByteBuffer b1, ByteBuffer b2) {
        if (b1 == b2) {
            return 0;
        }
        return BestHolder.BEST.compare(b1, b2);
    }

    public static void copy(ByteBuffer src, int srcPosition, byte[] trg, int trgPosition, int length) {
        BestHolder.BEST.copy(src, srcPosition, trg, trgPosition, length);
    }

    public static void copy(ByteBuffer src, int srcPosition, ByteBuffer trg, int trgPosition, int length) {
        BestHolder.BEST.copy(src, srcPosition, trg, trgPosition, length);
    }

    public static final class PureJavaOperations
    implements ByteOperations {
        @Override
        public int compare(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
            if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                return 0;
            }
            int end1 = offset1 + length1;
            int end2 = offset2 + length2;
            int i = offset1;
            for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
                int a = buffer1[i] & 0xFF;
                int b = buffer2[j] & 0xFF;
                if (a == b) continue;
                return a - b;
            }
            return length1 - length2;
        }

        @Override
        public int compare(ByteBuffer buffer1, byte[] buffer2, int offset2, int length2) {
            if (buffer1.hasArray()) {
                return this.compare(buffer1.array(), buffer1.arrayOffset() + buffer1.position(), buffer1.remaining(), buffer2, offset2, length2);
            }
            return this.compare(buffer1, ByteBuffer.wrap(buffer2, offset2, length2));
        }

        @Override
        public int compare(ByteBuffer buffer1, ByteBuffer buffer2) {
            int end1 = buffer1.limit();
            int end2 = buffer2.limit();
            int i = buffer1.position();
            for (int j = buffer2.position(); i < end1 && j < end2; ++i, ++j) {
                int b;
                int a = buffer1.get(i) & 0xFF;
                if (a == (b = buffer2.get(j) & 0xFF)) continue;
                return a - b;
            }
            return buffer1.remaining() - buffer2.remaining();
        }

        @Override
        public void copy(ByteBuffer src, int srcPosition, byte[] trg, int trgPosition, int length) {
            if (src.hasArray()) {
                System.arraycopy(src.array(), src.arrayOffset() + srcPosition, trg, trgPosition, length);
                return;
            }
            src = src.duplicate();
            src.position(srcPosition);
            src.get(trg, trgPosition, length);
        }

        @Override
        public void copy(ByteBuffer src, int srcPosition, ByteBuffer trg, int trgPosition, int length) {
            if (src.hasArray() && trg.hasArray()) {
                System.arraycopy(src.array(), src.arrayOffset() + srcPosition, trg.array(), trg.arrayOffset() + trgPosition, length);
                return;
            }
            src = src.duplicate();
            src.position(srcPosition).limit(srcPosition + length);
            trg = trg.duplicate();
            trg.position(trgPosition);
            trg.put(src);
        }
    }

    public static final class UnsafeOperations
    implements ByteOperations {
        static final Unsafe theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Field f = Unsafe.class.getDeclaredField("theUnsafe");
                    f.setAccessible(true);
                    return f.get(null);
                }
                catch (NoSuchFieldException e) {
                    throw new Error();
                }
                catch (IllegalAccessException e) {
                    throw new Error();
                }
            }
        });
        static final long BYTE_ARRAY_BASE_OFFSET;
        static final long DIRECT_BUFFER_ADDRESS_OFFSET;
        static final boolean littleEndian;
        private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

        static boolean lessThanUnsigned(long x1, long x2) {
            return x1 + Long.MIN_VALUE < x2 + Long.MIN_VALUE;
        }

        @Override
        public int compare(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
            return this.compareTo(buffer1, BYTE_ARRAY_BASE_OFFSET + (long)offset1, length1, buffer2, BYTE_ARRAY_BASE_OFFSET + (long)offset2, length2);
        }

        @Override
        public int compare(ByteBuffer buffer1, byte[] buffer2, int offset2, int length2) {
            int length1;
            long offset1;
            byte[] obj1;
            if (buffer1.hasArray()) {
                obj1 = buffer1.array();
                offset1 = BYTE_ARRAY_BASE_OFFSET + (long)buffer1.arrayOffset() + (long)buffer1.position();
                length1 = buffer1.remaining();
            } else {
                obj1 = null;
                offset1 = theUnsafe.getLong(buffer1, DIRECT_BUFFER_ADDRESS_OFFSET) + (long)buffer1.position();
                length1 = buffer1.remaining();
            }
            return this.compareTo(obj1, offset1, length1, buffer2, BYTE_ARRAY_BASE_OFFSET + (long)offset2, length2);
        }

        @Override
        public int compare(ByteBuffer buffer1, ByteBuffer buffer2) {
            int length2;
            long offset2;
            byte[] obj2;
            int length1;
            long offset1;
            byte[] obj1;
            if (buffer1.hasArray()) {
                obj1 = buffer1.array();
                offset1 = BYTE_ARRAY_BASE_OFFSET + (long)buffer1.arrayOffset() + (long)buffer1.position();
                length1 = buffer1.remaining();
            } else {
                obj1 = null;
                offset1 = theUnsafe.getLong(buffer1, DIRECT_BUFFER_ADDRESS_OFFSET) + (long)buffer1.position();
                length1 = buffer1.remaining();
            }
            if (buffer2.hasArray()) {
                obj2 = buffer2.array();
                offset2 = BYTE_ARRAY_BASE_OFFSET + (long)buffer2.arrayOffset() + (long)buffer2.position();
                length2 = buffer2.remaining();
            } else {
                obj2 = null;
                offset2 = theUnsafe.getLong(buffer2, DIRECT_BUFFER_ADDRESS_OFFSET) + (long)buffer2.position();
                length2 = buffer2.remaining();
            }
            return this.compareTo(obj1, offset1, length1, obj2, offset2, length2);
        }

        @Override
        public void copy(ByteBuffer src, int srcPosition, byte[] trg, int trgPosition, int length) {
            if (src.hasArray()) {
                System.arraycopy(src.array(), src.arrayOffset() + srcPosition, trg, trgPosition, length);
                return;
            }
            long srcOffset = (long)srcPosition + theUnsafe.getLong(src, DIRECT_BUFFER_ADDRESS_OFFSET);
            UnsafeOperations.copy(null, srcOffset, trg, BYTE_ARRAY_BASE_OFFSET + (long)trgPosition, length);
        }

        @Override
        public void copy(ByteBuffer srcBuf, int srcPosition, ByteBuffer trgBuf, int trgPosition, int length) {
            byte[] trg;
            long trgOffset;
            byte[] src;
            long srcOffset;
            if (srcBuf.hasArray() && trgBuf.hasArray()) {
                System.arraycopy(srcBuf.array(), srcBuf.arrayOffset() + srcPosition, trgBuf.array(), trgBuf.arrayOffset() + trgPosition, length);
                return;
            }
            if (srcBuf.isDirect()) {
                srcOffset = (long)srcPosition + theUnsafe.getLong(srcBuf, DIRECT_BUFFER_ADDRESS_OFFSET);
                src = null;
            } else {
                src = srcBuf.array();
                srcOffset = BYTE_ARRAY_BASE_OFFSET + (long)srcBuf.arrayOffset() + (long)srcPosition;
            }
            if (trgBuf.isDirect()) {
                trgOffset = (long)trgPosition + theUnsafe.getLong(trgBuf, DIRECT_BUFFER_ADDRESS_OFFSET);
                trg = null;
            } else {
                trg = trgBuf.array();
                trgOffset = BYTE_ARRAY_BASE_OFFSET + (long)trgBuf.arrayOffset() + (long)trgPosition;
            }
            UnsafeOperations.copy(src, srcOffset, trg, trgOffset, length);
        }

        static void copy(Object src, long srcOffset, Object dst, long dstOffset, long length) {
            while (length > 0L) {
                long size = length > 0x100000L ? 0x100000L : length;
                theUnsafe.copyMemory(src, srcOffset, dst, dstOffset, size);
                length -= size;
                srcOffset += size;
                dstOffset += size;
            }
        }

        public int compareTo(Object buffer1, long memoryOffset1, int length1, Object buffer2, long memoryOffset2, int length2) {
            int i;
            if (buffer1 == buffer2 && memoryOffset1 == memoryOffset2 && length1 == length2) {
                return 0;
            }
            int minLength = Math.min(length1, length2);
            int minWords = minLength / 8;
            int wordComparisons = minWords * 8;
            for (i = 0; i < wordComparisons; i += 8) {
                int y;
                long rw;
                long lw = theUnsafe.getLong(buffer1, memoryOffset1 + (long)i);
                long diff = lw ^ (rw = theUnsafe.getLong(buffer2, memoryOffset2 + (long)i));
                if (diff == 0L) continue;
                if (!littleEndian) {
                    return UnsafeOperations.lessThanUnsigned(lw, rw) ? -1 : 1;
                }
                int n = 0;
                int x = (int)diff;
                if (x == 0) {
                    x = (int)(diff >>> 32);
                    n = 32;
                }
                if ((y = x << 16) == 0) {
                    n += 16;
                } else {
                    x = y;
                }
                y = x << 8;
                if (y == 0) {
                    n += 8;
                }
                return (int)((lw >>> n & 0xFFL) - (rw >>> n & 0xFFL));
            }
            for (i = minWords * 8; i < minLength; ++i) {
                int result = UnsignedBytes.compare((byte)theUnsafe.getByte(buffer1, memoryOffset1 + (long)i), (byte)theUnsafe.getByte(buffer2, memoryOffset2 + (long)i));
                if (result == 0) continue;
                return result;
            }
            return length1 - length2;
        }

        static {
            try {
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                DIRECT_BUFFER_ADDRESS_OFFSET = theUnsafe.objectFieldOffset(Buffer.class.getDeclaredField("address"));
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                throw new AssertionError();
            }
            littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
        }
    }

    private static class BestHolder {
        static final String UNSAFE_COMPARER_NAME = FastByteOperations.class.getName() + "$UnsafeOperations";
        static final ByteOperations BEST = BestHolder.getBest();

        private BestHolder() {
        }

        static ByteOperations getBest() {
            boolean unaligned;
            String arch = System.getProperty("os.arch");
            boolean bl = unaligned = arch.equals("i386") || arch.equals("x86") || arch.equals("amd64") || arch.equals("x86_64");
            if (!unaligned) {
                return new PureJavaOperations();
            }
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARER_NAME);
                ByteOperations comparer = (ByteOperations)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return comparer;
            }
            catch (Throwable t) {
                return new PureJavaOperations();
            }
        }
    }

    public static interface ByteOperations {
        public int compare(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

        public int compare(ByteBuffer var1, byte[] var2, int var3, int var4);

        public int compare(ByteBuffer var1, ByteBuffer var2);

        public void copy(ByteBuffer var1, int var2, byte[] var3, int var4, int var5);

        public void copy(ByteBuffer var1, int var2, ByteBuffer var3, int var4, int var5);
    }
}

