/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

public abstract class MemoryUtil {
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private static final Unsafe unsafe;
    private static final Class<?> DIRECT_BYTE_BUFFER_CLASS;
    private static final long DIRECT_BYTE_BUFFER_ADDRESS_OFFSET;
    private static final long DIRECT_BYTE_BUFFER_CAPACITY_OFFSET;
    private static final long DIRECT_BYTE_BUFFER_LIMIT_OFFSET;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final boolean BIG_ENDIAN;
    private static final boolean UNALIGNED;
    public static final boolean INVERTED_ORDER;

    public static void setByte(long address, byte b) {
        unsafe.putByte(address, b);
    }

    public static void setShort(long address, short s) {
        unsafe.putShort(address, s);
    }

    public static void setInt(long address, int l) {
        if (UNALIGNED) {
            unsafe.putInt(address, l);
        } else {
            MemoryUtil.putIntByByte(address, l);
        }
    }

    public static void setLong(long address, long l) {
        if (UNALIGNED) {
            unsafe.putLong(address, l);
        } else {
            MemoryUtil.putLongByByte(address, l);
        }
    }

    public static byte getByte(long address) {
        return unsafe.getByte(address);
    }

    public static int getShort(long address) {
        return UNALIGNED ? (int)unsafe.getShort(address) : MemoryUtil.getShortByByte(address);
    }

    public static int getInt(long address) {
        return UNALIGNED ? unsafe.getInt(address) : MemoryUtil.getIntByByte(address);
    }

    public static long getLong(long address) {
        return UNALIGNED ? unsafe.getLong(address) : MemoryUtil.getLongByByte(address);
    }

    public static ByteBuffer getByteBuffer(long address, int length) {
        ByteBuffer instance;
        try {
            instance = (ByteBuffer)unsafe.allocateInstance(DIRECT_BYTE_BUFFER_CLASS);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        unsafe.putLong(instance, DIRECT_BYTE_BUFFER_ADDRESS_OFFSET, address);
        unsafe.putInt(instance, DIRECT_BYTE_BUFFER_CAPACITY_OFFSET, length);
        unsafe.putInt(instance, DIRECT_BYTE_BUFFER_LIMIT_OFFSET, length);
        instance.order(ByteOrder.nativeOrder());
        return instance;
    }

    public static long getLongByByte(long address) {
        if (BIG_ENDIAN) {
            return (long)unsafe.getByte(address) << 56 | ((long)unsafe.getByte(address + 1L) & 0xFFL) << 48 | ((long)unsafe.getByte(address + 2L) & 0xFFL) << 40 | ((long)unsafe.getByte(address + 3L) & 0xFFL) << 32 | ((long)unsafe.getByte(address + 4L) & 0xFFL) << 24 | ((long)unsafe.getByte(address + 5L) & 0xFFL) << 16 | ((long)unsafe.getByte(address + 6L) & 0xFFL) << 8 | (long)unsafe.getByte(address + 7L) & 0xFFL;
        }
        return (long)unsafe.getByte(address + 7L) << 56 | ((long)unsafe.getByte(address + 6L) & 0xFFL) << 48 | ((long)unsafe.getByte(address + 5L) & 0xFFL) << 40 | ((long)unsafe.getByte(address + 4L) & 0xFFL) << 32 | ((long)unsafe.getByte(address + 3L) & 0xFFL) << 24 | ((long)unsafe.getByte(address + 2L) & 0xFFL) << 16 | ((long)unsafe.getByte(address + 1L) & 0xFFL) << 8 | (long)unsafe.getByte(address) & 0xFFL;
    }

    public static int getIntByByte(long address) {
        if (BIG_ENDIAN) {
            return unsafe.getByte(address) << 24 | (unsafe.getByte(address + 1L) & 0xFF) << 16 | (unsafe.getByte(address + 2L) & 0xFF) << 8 | unsafe.getByte(address + 3L) & 0xFF;
        }
        return unsafe.getByte(address + 3L) << 24 | (unsafe.getByte(address + 2L) & 0xFF) << 16 | (unsafe.getByte(address + 1L) & 0xFF) << 8 | unsafe.getByte(address) & 0xFF;
    }

    public static int getShortByByte(long address) {
        if (BIG_ENDIAN) {
            return unsafe.getByte(address) << 8 | unsafe.getByte(address + 1L) & 0xFF;
        }
        return unsafe.getByte(address + 1L) << 8 | unsafe.getByte(address) & 0xFF;
    }

    public static void putLongByByte(long address, long value) {
        if (BIG_ENDIAN) {
            unsafe.putByte(address, (byte)(value >> 56));
            unsafe.putByte(address + 1L, (byte)(value >> 48));
            unsafe.putByte(address + 2L, (byte)(value >> 40));
            unsafe.putByte(address + 3L, (byte)(value >> 32));
            unsafe.putByte(address + 4L, (byte)(value >> 24));
            unsafe.putByte(address + 5L, (byte)(value >> 16));
            unsafe.putByte(address + 6L, (byte)(value >> 8));
            unsafe.putByte(address + 7L, (byte)value);
        } else {
            unsafe.putByte(address + 7L, (byte)(value >> 56));
            unsafe.putByte(address + 6L, (byte)(value >> 48));
            unsafe.putByte(address + 5L, (byte)(value >> 40));
            unsafe.putByte(address + 4L, (byte)(value >> 32));
            unsafe.putByte(address + 3L, (byte)(value >> 24));
            unsafe.putByte(address + 2L, (byte)(value >> 16));
            unsafe.putByte(address + 1L, (byte)(value >> 8));
            unsafe.putByte(address, (byte)value);
        }
    }

    public static void putIntByByte(long address, int value) {
        if (BIG_ENDIAN) {
            unsafe.putByte(address, (byte)(value >> 24));
            unsafe.putByte(address + 1L, (byte)(value >> 16));
            unsafe.putByte(address + 2L, (byte)(value >> 8));
            unsafe.putByte(address + 3L, (byte)value);
        } else {
            unsafe.putByte(address + 3L, (byte)(value >> 24));
            unsafe.putByte(address + 2L, (byte)(value >> 16));
            unsafe.putByte(address + 1L, (byte)(value >> 8));
            unsafe.putByte(address, (byte)value);
        }
    }

    public static void setBytes(long address, ByteBuffer buffer) {
        int start = buffer.position();
        int count = buffer.limit() - start;
        if (count == 0) {
            return;
        }
        if (buffer.isDirect()) {
            MemoryUtil.setBytes(unsafe.getLong(buffer, DIRECT_BYTE_BUFFER_ADDRESS_OFFSET) + (long)start, address, count);
        } else {
            MemoryUtil.setBytes(address, buffer.array(), start, count);
        }
    }

    public static void setBytes(long address, byte[] buffer, int bufferOffset, int count) {
        assert (buffer != null);
        assert (bufferOffset >= 0 && count >= 0 && bufferOffset + count <= buffer.length);
        MemoryUtil.setBytes(buffer, bufferOffset, address, (long)count);
    }

    public static void setBytes(long src, long trg, long count) {
        while (count > 0L) {
            long size = count > 0x100000L ? 0x100000L : count;
            unsafe.copyMemory(src, trg, size);
            count -= size;
            src += size;
            trg += size;
        }
    }

    public static void setBytes(byte[] src, int offset, long trg, long count) {
        while (count > 0L) {
            long size = count > 0x100000L ? 0x100000L : count;
            unsafe.copyMemory(src, BYTE_ARRAY_BASE_OFFSET + (long)offset, null, trg, size);
            count -= size;
            offset = (int)((long)offset + size);
            trg += size;
        }
    }

    public static void getBytes(long address, byte[] buffer, int bufferOffset, int count) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (bufferOffset < 0 || count < 0 || count > buffer.length - bufferOffset) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        unsafe.copyMemory(null, address, buffer, BYTE_ARRAY_BASE_OFFSET + (long)bufferOffset, count);
    }

    static {
        BIG_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        String arch = System.getProperty("os.arch");
        UNALIGNED = arch.equals("i386") || arch.equals("x86") || arch.equals("amd64") || arch.equals("x86_64");
        INVERTED_ORDER = UNALIGNED && !BIG_ENDIAN;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            Class<?> clazz = ByteBuffer.allocateDirect(0).getClass();
            DIRECT_BYTE_BUFFER_ADDRESS_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("address"));
            DIRECT_BYTE_BUFFER_CAPACITY_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("capacity"));
            DIRECT_BYTE_BUFFER_LIMIT_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("limit"));
            DIRECT_BYTE_BUFFER_CLASS = clazz;
            BYTE_ARRAY_BASE_OFFSET = unsafe.arrayBaseOffset(byte[].class);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

