/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.ByteArrayStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.MissingStreamSource;
import com.facebook.presto.orc.stream.RowGroupDictionaryLengthStream;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.SliceArrayBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SliceDictionaryStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private StreamSource<BooleanStream> presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream presentStream;
    private boolean[] isNullVector = new boolean[0];
    @Nonnull
    private StreamSource<ByteArrayStream> dictionaryDataStreamSource = MissingStreamSource.missingStreamSource(ByteArrayStream.class);
    private boolean dictionaryOpen;
    private int dictionarySize;
    @Nonnull
    private Slice[] dictionary = new Slice[1];
    private Block dictionaryBlock = this.createNewDictionaryBlock();
    @Nonnull
    private StreamSource<LongStream> dictionaryLengthStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
    @Nonnull
    private StreamSource<BooleanStream> inDictionaryStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream inDictionaryStream;
    private boolean[] inDictionary = new boolean[0];
    @Nonnull
    private StreamSource<ByteArrayStream> rowGroupDictionaryDataStreamSource = MissingStreamSource.missingStreamSource(ByteArrayStream.class);
    @Nonnull
    private Slice[] rowGroupDictionary = new Slice[0];
    @Nonnull
    private StreamSource<RowGroupDictionaryLengthStream> rowGroupDictionaryLengthStreamSource = MissingStreamSource.missingStreamSource(RowGroupDictionaryLengthStream.class);
    @Nonnull
    private int[] rowGroupDictionaryLength = new int[0];
    @Nonnull
    private StreamSource<LongStream> dataStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
    @Nullable
    private LongStream dataStream;
    @Nonnull
    private int[] dataVector = new int[0];
    private boolean rowGroupOpen;

    public SliceDictionaryStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        Block block;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException("Value is not null but data stream is not present");
                }
                if (this.inDictionaryStream != null) {
                    this.inDictionaryStream.skip(this.readOffset);
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        if (this.isNullVector.length < this.nextBatchSize) {
            this.isNullVector = new boolean[this.nextBatchSize];
        }
        if (this.dataVector.length < this.nextBatchSize) {
            this.dataVector = new int[this.nextBatchSize];
        }
        if (this.presentStream == null) {
            if (this.dataStream == null) {
                throw new OrcCorruptionException("Value is not null but data stream is not present");
            }
            Arrays.fill(this.isNullVector, false);
            this.dataStream.nextIntVector(this.nextBatchSize, this.dataVector);
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, this.isNullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException("Value is not null but data stream is not present");
                }
                this.dataStream.nextIntVector(this.nextBatchSize, this.dataVector, this.isNullVector);
            }
        }
        if (this.inDictionary.length < this.nextBatchSize) {
            this.inDictionary = new boolean[this.nextBatchSize];
        }
        if (this.inDictionaryStream == null) {
            Arrays.fill(this.inDictionary, true);
        } else {
            this.inDictionaryStream.getSetBits(this.nextBatchSize, this.inDictionary, this.isNullVector);
        }
        boolean rowGroupDictionaryReferenced = false;
        for (int i = 0; i < this.nextBatchSize; ++i) {
            if (this.isNullVector[i] || this.inDictionary[i]) continue;
            rowGroupDictionaryReferenced = true;
            break;
        }
        if (rowGroupDictionaryReferenced) {
            BlockBuilder builder = type.createBlockBuilder(new BlockBuilderStatus(), this.nextBatchSize);
            for (int i = 0; i < this.nextBatchSize; ++i) {
                if (this.isNullVector[i]) {
                    builder.appendNull();
                    continue;
                }
                if (this.inDictionary[i]) {
                    type.writeSlice(builder, this.dictionary[this.dataVector[i]]);
                    continue;
                }
                type.writeSlice(builder, this.rowGroupDictionary[this.dataVector[i]]);
            }
            block = builder.build();
        } else {
            for (int i = 0; i < this.dataVector.length; ++i) {
                if (!this.isNullVector[i]) continue;
                this.dataVector[i] = this.dictionarySize;
            }
            Slice ids = Slices.wrappedIntArray((int[])Arrays.copyOfRange(this.dataVector, 0, this.nextBatchSize));
            block = new DictionaryBlock(this.nextBatchSize, this.dictionaryBlock, ids);
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private Block createNewDictionaryBlock() {
        return new SliceArrayBlock(this.dictionary.length, this.dictionary, true);
    }

    private void openRowGroup() throws IOException {
        ByteArrayStream dictionaryDataStream;
        if (!this.dictionaryOpen) {
            this.dictionary = new Slice[this.dictionarySize + 1];
            this.dictionaryBlock = this.createNewDictionaryBlock();
            if (this.dictionarySize > 0) {
                int[] dictionaryLength = new int[this.dictionarySize];
                LongStream lengthStream = this.dictionaryLengthStreamSource.openStream();
                if (lengthStream == null) {
                    throw new OrcCorruptionException("Dictionary is not empty but dictionary length stream is not present");
                }
                lengthStream.nextIntVector(this.dictionarySize, dictionaryLength);
                dictionaryDataStream = this.dictionaryDataStreamSource.openStream();
                SliceDictionaryStreamReader.readDictionary(dictionaryDataStream, this.dictionarySize, dictionaryLength, this.dictionary);
            }
        }
        this.dictionaryOpen = true;
        RowGroupDictionaryLengthStream dictionaryLengthStream = this.rowGroupDictionaryLengthStreamSource.openStream();
        if (dictionaryLengthStream != null) {
            int rowGroupDictionarySize = dictionaryLengthStream.getEntryCount();
            if (this.rowGroupDictionary.length < rowGroupDictionarySize) {
                this.rowGroupDictionary = new Slice[rowGroupDictionarySize];
                this.rowGroupDictionaryLength = new int[rowGroupDictionarySize];
            }
            dictionaryLengthStream.nextIntVector(rowGroupDictionarySize, this.rowGroupDictionaryLength);
            dictionaryDataStream = this.rowGroupDictionaryDataStreamSource.openStream();
            SliceDictionaryStreamReader.readDictionary(dictionaryDataStream, rowGroupDictionarySize, this.rowGroupDictionaryLength, this.rowGroupDictionary);
        }
        this.presentStream = this.presentStreamSource.openStream();
        this.inDictionaryStream = this.inDictionaryStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private static void readDictionary(@Nullable ByteArrayStream dictionaryDataStream, int dictionarySize, int[] dictionaryLength, Slice[] dictionary) throws IOException {
        for (int i = 0; i < dictionarySize; ++i) {
            int length = dictionaryLength[i];
            dictionary[i] = length == 0 ? Slices.EMPTY_SLICE : Slices.wrappedBuffer((byte[])dictionaryDataStream.next(length));
        }
    }

    @Override
    public void startStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.dictionaryDataStreamSource = dictionaryStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, ByteArrayStream.class);
        this.dictionaryLengthStreamSource = dictionaryStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongStream.class);
        this.dictionarySize = encoding.get(this.streamDescriptor.getStreamId()).getDictionarySize();
        this.dictionaryOpen = false;
        this.presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.dataStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
        this.inDictionaryStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.rowGroupDictionaryLengthStreamSource = MissingStreamSource.missingStreamSource(RowGroupDictionaryLengthStream.class);
        this.rowGroupDictionaryDataStreamSource = MissingStreamSource.missingStreamSource(ByteArrayStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class);
        this.dataStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongStream.class);
        this.inDictionaryStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.IN_DICTIONARY, BooleanStream.class);
        this.rowGroupDictionaryLengthStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY_LENGTH, RowGroupDictionaryLengthStream.class);
        this.rowGroupDictionaryDataStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY, ByteArrayStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

