/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveStorageFormat;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import java.io.File;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTimeZone;

@DefunctConfig(value={"hive.file-system-cache-ttl", "hive.max-global-split-iterator-threads", "hive.optimized-reader.enabled"})
public class HiveClientConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private String timeZone = TimeZone.getDefault().getID();
    private DataSize maxSplitSize = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private int maxOutstandingSplits = 1000;
    private int maxSplitIteratorThreads = 1000;
    private int minPartitionBatchSize = 10;
    private int maxPartitionBatchSize = 100;
    private int maxInitialSplits = 200;
    private DataSize maxInitialSplitSize;
    private int domainCompactionThreshold = 100;
    private boolean forceLocalScheduling;
    private boolean recursiveDirWalkerEnabled;
    private int maxConcurrentFileRenames = 20;
    private boolean allowAddColumn;
    private boolean allowDropTable;
    private boolean allowRenameTable;
    private boolean allowRenameColumn;
    private boolean allowCorruptWritesForTesting;
    private Duration metastoreCacheTtl = new Duration(1.0, TimeUnit.HOURS);
    private Duration metastoreRefreshInterval = new Duration(1.0, TimeUnit.SECONDS);
    private int maxMetastoreRefreshThreads = 100;
    private HostAndPort metastoreSocksProxy;
    private Duration metastoreTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private Duration dfsTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private Duration dfsConnectTimeout = new Duration(500.0, TimeUnit.MILLISECONDS);
    private int dfsConnectMaxRetries = 5;
    private boolean verifyChecksum = true;
    private String domainSocketPath;
    private String s3AwsAccessKey;
    private String s3AwsSecretKey;
    private boolean s3UseInstanceCredentials = true;
    private boolean s3SslEnabled = true;
    private boolean s3SseEnabled;
    private int s3MaxClientRetries = 3;
    private int s3MaxErrorRetries = 10;
    private Duration s3MaxBackoffTime = new Duration(10.0, TimeUnit.MINUTES);
    private Duration s3MaxRetryTime = new Duration(10.0, TimeUnit.MINUTES);
    private Duration s3ConnectTimeout = new Duration(5.0, TimeUnit.SECONDS);
    private Duration s3SocketTimeout = new Duration(5.0, TimeUnit.SECONDS);
    private int s3MaxConnections = 500;
    private File s3StagingDirectory = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value());
    private DataSize s3MultipartMinFileSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize s3MultipartMinPartSize = new DataSize(5.0, DataSize.Unit.MEGABYTE);
    private boolean useParquetColumnNames;
    private boolean pinS3ClientToCurrentRegion;
    private HiveStorageFormat hiveStorageFormat = HiveStorageFormat.RCBINARY;
    private HiveCompressionCodec hiveCompressionCodec = HiveCompressionCodec.GZIP;
    private boolean respectTableFormat = true;
    private boolean immutablePartitions;
    private int maxPartitionsPerWriter = 100;
    private List<String> resourceConfigFiles;
    private boolean parquetOptimizedReaderEnabled;
    private boolean parquetPredicatePushdownEnabled;
    private boolean assumeCanonicalPartitionKeys;
    private boolean useOrcColumnNames;
    private DataSize orcMaxMergeDistance = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private DataSize orcMaxBufferSize = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private DataSize orcStreamBufferSize = new DataSize(8.0, DataSize.Unit.MEGABYTE);

    public int getMaxInitialSplits() {
        return this.maxInitialSplits;
    }

    @Config(value="hive.max-initial-splits")
    public HiveClientConfig setMaxInitialSplits(int maxInitialSplits) {
        this.maxInitialSplits = maxInitialSplits;
        return this;
    }

    public DataSize getMaxInitialSplitSize() {
        if (this.maxInitialSplitSize == null) {
            return new DataSize(this.maxSplitSize.getValue() / 2.0, this.maxSplitSize.getUnit());
        }
        return this.maxInitialSplitSize;
    }

    @Config(value="hive.max-initial-split-size")
    public HiveClientConfig setMaxInitialSplitSize(DataSize maxInitialSplitSize) {
        this.maxInitialSplitSize = maxInitialSplitSize;
        return this;
    }

    @Min(value=1L)
    public int getDomainCompactionThreshold() {
        return this.domainCompactionThreshold;
    }

    @Config(value="hive.domain-compaction-threshold")
    @ConfigDescription(value="Maximum ranges to allow in a tuple domain without compacting it")
    public HiveClientConfig setDomainCompactionThreshold(int domainCompactionThreshold) {
        this.domainCompactionThreshold = domainCompactionThreshold;
        return this;
    }

    public boolean isForceLocalScheduling() {
        return this.forceLocalScheduling;
    }

    @Config(value="hive.force-local-scheduling")
    public HiveClientConfig setForceLocalScheduling(boolean forceLocalScheduling) {
        this.forceLocalScheduling = forceLocalScheduling;
        return this;
    }

    @Min(value=1L)
    public int getMaxConcurrentFileRenames() {
        return this.maxConcurrentFileRenames;
    }

    @Config(value="hive.max-concurrent-file-renames")
    public HiveClientConfig setMaxConcurrentFileRenames(int maxConcurrentFileRenames) {
        this.maxConcurrentFileRenames = maxConcurrentFileRenames;
        return this;
    }

    @Config(value="hive.recursive-directories")
    public HiveClientConfig setRecursiveDirWalkerEnabled(boolean recursiveDirWalkerEnabled) {
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        return this;
    }

    public boolean getRecursiveDirWalkerEnabled() {
        return this.recursiveDirWalkerEnabled;
    }

    public DateTimeZone getDateTimeZone() {
        return DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(this.timeZone));
    }

    @NotNull
    public String getTimeZone() {
        return this.timeZone;
    }

    @Config(value="hive.time-zone")
    public HiveClientConfig setTimeZone(String id) {
        this.timeZone = id != null ? id : TimeZone.getDefault().getID();
        return this;
    }

    @NotNull
    public DataSize getMaxSplitSize() {
        return this.maxSplitSize;
    }

    @Config(value="hive.max-split-size")
    public HiveClientConfig setMaxSplitSize(DataSize maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
        return this;
    }

    @Min(value=1L)
    public int getMaxOutstandingSplits() {
        return this.maxOutstandingSplits;
    }

    @Config(value="hive.max-outstanding-splits")
    public HiveClientConfig setMaxOutstandingSplits(int maxOutstandingSplits) {
        this.maxOutstandingSplits = maxOutstandingSplits;
        return this;
    }

    @Min(value=1L)
    public int getMaxSplitIteratorThreads() {
        return this.maxSplitIteratorThreads;
    }

    @Config(value="hive.max-split-iterator-threads")
    public HiveClientConfig setMaxSplitIteratorThreads(int maxSplitIteratorThreads) {
        this.maxSplitIteratorThreads = maxSplitIteratorThreads;
        return this;
    }

    public boolean getAllowRenameTable() {
        return this.allowRenameTable;
    }

    @Config(value="hive.allow-rename-table")
    @ConfigDescription(value="Allow hive connector to rename table")
    public HiveClientConfig setAllowRenameTable(boolean allowRenameTable) {
        this.allowRenameTable = allowRenameTable;
        return this;
    }

    public boolean getAllowRenameColumn() {
        return this.allowRenameColumn;
    }

    @Config(value="hive.allow-rename-column")
    @ConfigDescription(value="Allow hive connector to rename column")
    public HiveClientConfig setAllowRenameColumn(boolean allowRenameColumn) {
        this.allowRenameColumn = allowRenameColumn;
        return this;
    }

    @Deprecated
    public boolean getAllowCorruptWritesForTesting() {
        return this.allowCorruptWritesForTesting;
    }

    @Deprecated
    @Config(value="hive.allow-corrupt-writes-for-testing")
    @ConfigDescription(value="Allow Hive connector to write data even when data will likely be corrupt")
    public HiveClientConfig setAllowCorruptWritesForTesting(boolean allowCorruptWritesForTesting) {
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        return this;
    }

    public boolean getAllowAddColumn() {
        return this.allowAddColumn;
    }

    @Config(value="hive.allow-add-column")
    @ConfigDescription(value="Allow Hive connector to add column")
    public HiveClientConfig setAllowAddColumn(boolean allowAddColumn) {
        this.allowAddColumn = allowAddColumn;
        return this;
    }

    public boolean getAllowDropTable() {
        return this.allowDropTable;
    }

    @Config(value="hive.allow-drop-table")
    @ConfigDescription(value="Allow Hive connector to drop table")
    public HiveClientConfig setAllowDropTable(boolean allowDropTable) {
        this.allowDropTable = allowDropTable;
        return this;
    }

    @NotNull
    public Duration getMetastoreCacheTtl() {
        return this.metastoreCacheTtl;
    }

    @Config(value="hive.metastore-cache-ttl")
    public HiveClientConfig setMetastoreCacheTtl(Duration metastoreCacheTtl) {
        this.metastoreCacheTtl = metastoreCacheTtl;
        return this;
    }

    @NotNull
    public Duration getMetastoreRefreshInterval() {
        return this.metastoreRefreshInterval;
    }

    @Config(value="hive.metastore-refresh-interval")
    public HiveClientConfig setMetastoreRefreshInterval(Duration metastoreRefreshInterval) {
        this.metastoreRefreshInterval = metastoreRefreshInterval;
        return this;
    }

    @Min(value=1L)
    public int getMaxMetastoreRefreshThreads() {
        return this.maxMetastoreRefreshThreads;
    }

    @Config(value="hive.metastore-refresh-max-threads")
    public HiveClientConfig setMaxMetastoreRefreshThreads(int maxMetastoreRefreshThreads) {
        this.maxMetastoreRefreshThreads = maxMetastoreRefreshThreads;
        return this;
    }

    public HostAndPort getMetastoreSocksProxy() {
        return this.metastoreSocksProxy;
    }

    @Config(value="hive.metastore.thrift.client.socks-proxy")
    public HiveClientConfig setMetastoreSocksProxy(HostAndPort metastoreSocksProxy) {
        this.metastoreSocksProxy = metastoreSocksProxy;
        return this;
    }

    @NotNull
    public Duration getMetastoreTimeout() {
        return this.metastoreTimeout;
    }

    @Config(value="hive.metastore-timeout")
    public HiveClientConfig setMetastoreTimeout(Duration metastoreTimeout) {
        this.metastoreTimeout = metastoreTimeout;
        return this;
    }

    @Min(value=1L)
    public int getMinPartitionBatchSize() {
        return this.minPartitionBatchSize;
    }

    @Config(value="hive.metastore.partition-batch-size.min")
    public HiveClientConfig setMinPartitionBatchSize(int minPartitionBatchSize) {
        this.minPartitionBatchSize = minPartitionBatchSize;
        return this;
    }

    @Min(value=1L)
    public int getMaxPartitionBatchSize() {
        return this.maxPartitionBatchSize;
    }

    @Config(value="hive.metastore.partition-batch-size.max")
    public HiveClientConfig setMaxPartitionBatchSize(int maxPartitionBatchSize) {
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        return this;
    }

    public List<String> getResourceConfigFiles() {
        return this.resourceConfigFiles;
    }

    @Config(value="hive.config.resources")
    public HiveClientConfig setResourceConfigFiles(String files) {
        this.resourceConfigFiles = files == null ? null : SPLITTER.splitToList((CharSequence)files);
        return this;
    }

    public HiveClientConfig setResourceConfigFiles(List<String> files) {
        this.resourceConfigFiles = files == null ? null : ImmutableList.copyOf(files);
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getDfsTimeout() {
        return this.dfsTimeout;
    }

    @Config(value="hive.dfs-timeout")
    public HiveClientConfig setDfsTimeout(Duration dfsTimeout) {
        this.dfsTimeout = dfsTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getDfsConnectTimeout() {
        return this.dfsConnectTimeout;
    }

    @Config(value="hive.dfs.connect.timeout")
    public HiveClientConfig setDfsConnectTimeout(Duration dfsConnectTimeout) {
        this.dfsConnectTimeout = dfsConnectTimeout;
        return this;
    }

    @Min(value=0L)
    public int getDfsConnectMaxRetries() {
        return this.dfsConnectMaxRetries;
    }

    @Config(value="hive.dfs.connect.max-retries")
    public HiveClientConfig setDfsConnectMaxRetries(int dfsConnectMaxRetries) {
        this.dfsConnectMaxRetries = dfsConnectMaxRetries;
        return this;
    }

    public HiveStorageFormat getHiveStorageFormat() {
        return this.hiveStorageFormat;
    }

    @Config(value="hive.storage-format")
    public HiveClientConfig setHiveStorageFormat(HiveStorageFormat hiveStorageFormat) {
        this.hiveStorageFormat = hiveStorageFormat;
        return this;
    }

    public HiveCompressionCodec getHiveCompressionCodec() {
        return this.hiveCompressionCodec;
    }

    @Config(value="hive.compression-codec")
    public HiveClientConfig setHiveCompressionCodec(HiveCompressionCodec hiveCompressionCodec) {
        this.hiveCompressionCodec = hiveCompressionCodec;
        return this;
    }

    public boolean isRespectTableFormat() {
        return this.respectTableFormat;
    }

    @Config(value="hive.respect-table-format")
    @ConfigDescription(value="Should new partitions be written using the existing table format or the default Presto format")
    public HiveClientConfig setRespectTableFormat(boolean respectTableFormat) {
        this.respectTableFormat = respectTableFormat;
        return this;
    }

    public boolean isImmutablePartitions() {
        return this.immutablePartitions;
    }

    @Config(value="hive.immutable-partitions")
    @ConfigDescription(value="Can new data be inserted into existing partitions or existing unpartitioned tables")
    public HiveClientConfig setImmutablePartitions(boolean immutablePartitions) {
        this.immutablePartitions = immutablePartitions;
        return this;
    }

    @Min(value=1L)
    public int getMaxPartitionsPerWriter() {
        return this.maxPartitionsPerWriter;
    }

    @Config(value="hive.max-partitions-per-writers")
    @ConfigDescription(value="Maximum number of partitions per writer")
    public HiveClientConfig setMaxPartitionsPerWriter(int maxPartitionsPerWriter) {
        this.maxPartitionsPerWriter = maxPartitionsPerWriter;
        return this;
    }

    public String getDomainSocketPath() {
        return this.domainSocketPath;
    }

    @Config(value="hive.dfs.domain-socket-path")
    @LegacyConfig(value={"dfs.domain-socket-path"})
    public HiveClientConfig setDomainSocketPath(String domainSocketPath) {
        this.domainSocketPath = domainSocketPath;
        return this;
    }

    public boolean isVerifyChecksum() {
        return this.verifyChecksum;
    }

    @Config(value="hive.dfs.verify-checksum")
    public HiveClientConfig setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
        return this;
    }

    public String getS3AwsAccessKey() {
        return this.s3AwsAccessKey;
    }

    @Config(value="hive.s3.aws-access-key")
    public HiveClientConfig setS3AwsAccessKey(String s3AwsAccessKey) {
        this.s3AwsAccessKey = s3AwsAccessKey;
        return this;
    }

    public String getS3AwsSecretKey() {
        return this.s3AwsSecretKey;
    }

    @Config(value="hive.s3.aws-secret-key")
    public HiveClientConfig setS3AwsSecretKey(String s3AwsSecretKey) {
        this.s3AwsSecretKey = s3AwsSecretKey;
        return this;
    }

    public boolean isS3UseInstanceCredentials() {
        return this.s3UseInstanceCredentials;
    }

    @Config(value="hive.s3.use-instance-credentials")
    public HiveClientConfig setS3UseInstanceCredentials(boolean s3UseInstanceCredentials) {
        this.s3UseInstanceCredentials = s3UseInstanceCredentials;
        return this;
    }

    public boolean isS3SslEnabled() {
        return this.s3SslEnabled;
    }

    @Config(value="hive.s3.ssl.enabled")
    public HiveClientConfig setS3SslEnabled(boolean s3SslEnabled) {
        this.s3SslEnabled = s3SslEnabled;
        return this;
    }

    public boolean isS3SseEnabled() {
        return this.s3SseEnabled;
    }

    @Config(value="hive.s3.sse.enabled")
    @ConfigDescription(value="Enable S3 server side encryption")
    public HiveClientConfig setS3SseEnabled(boolean s3SseEnabled) {
        this.s3SseEnabled = s3SseEnabled;
        return this;
    }

    @Min(value=0L)
    public int getS3MaxClientRetries() {
        return this.s3MaxClientRetries;
    }

    @Config(value="hive.s3.max-client-retries")
    public HiveClientConfig setS3MaxClientRetries(int s3MaxClientRetries) {
        this.s3MaxClientRetries = s3MaxClientRetries;
        return this;
    }

    @Min(value=0L)
    public int getS3MaxErrorRetries() {
        return this.s3MaxErrorRetries;
    }

    @Config(value="hive.s3.max-error-retries")
    public HiveClientConfig setS3MaxErrorRetries(int s3MaxErrorRetries) {
        this.s3MaxErrorRetries = s3MaxErrorRetries;
        return this;
    }

    @MinDuration(value="1s")
    @NotNull
    public Duration getS3MaxBackoffTime() {
        return this.s3MaxBackoffTime;
    }

    @Config(value="hive.s3.max-backoff-time")
    public HiveClientConfig setS3MaxBackoffTime(Duration s3MaxBackoffTime) {
        this.s3MaxBackoffTime = s3MaxBackoffTime;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getS3MaxRetryTime() {
        return this.s3MaxRetryTime;
    }

    @Config(value="hive.s3.max-retry-time")
    public HiveClientConfig setS3MaxRetryTime(Duration s3MaxRetryTime) {
        this.s3MaxRetryTime = s3MaxRetryTime;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getS3ConnectTimeout() {
        return this.s3ConnectTimeout;
    }

    @Config(value="hive.s3.connect-timeout")
    public HiveClientConfig setS3ConnectTimeout(Duration s3ConnectTimeout) {
        this.s3ConnectTimeout = s3ConnectTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getS3SocketTimeout() {
        return this.s3SocketTimeout;
    }

    @Config(value="hive.s3.socket-timeout")
    public HiveClientConfig setS3SocketTimeout(Duration s3SocketTimeout) {
        this.s3SocketTimeout = s3SocketTimeout;
        return this;
    }

    @Min(value=1L)
    public int getS3MaxConnections() {
        return this.s3MaxConnections;
    }

    @Config(value="hive.s3.max-connections")
    public HiveClientConfig setS3MaxConnections(int s3MaxConnections) {
        this.s3MaxConnections = s3MaxConnections;
        return this;
    }

    @NotNull
    public File getS3StagingDirectory() {
        return this.s3StagingDirectory;
    }

    @Config(value="hive.s3.staging-directory")
    @ConfigDescription(value="Temporary directory for staging files before uploading to S3")
    public HiveClientConfig setS3StagingDirectory(File s3StagingDirectory) {
        this.s3StagingDirectory = s3StagingDirectory;
        return this;
    }

    @NotNull
    @MinDataSize(value="16MB")
    public DataSize getS3MultipartMinFileSize() {
        return this.s3MultipartMinFileSize;
    }

    @Config(value="hive.s3.multipart.min-file-size")
    @ConfigDescription(value="Minimum file size for an S3 multipart upload")
    public HiveClientConfig setS3MultipartMinFileSize(DataSize size) {
        this.s3MultipartMinFileSize = size;
        return this;
    }

    @NotNull
    @MinDataSize(value="5MB")
    public DataSize getS3MultipartMinPartSize() {
        return this.s3MultipartMinPartSize;
    }

    @Config(value="hive.s3.multipart.min-part-size")
    @ConfigDescription(value="Minimum part size for an S3 multipart upload")
    public HiveClientConfig setS3MultipartMinPartSize(DataSize size) {
        this.s3MultipartMinPartSize = size;
        return this;
    }

    public boolean isPinS3ClientToCurrentRegion() {
        return this.pinS3ClientToCurrentRegion;
    }

    @Config(value="hive.s3.pin-client-to-current-region")
    @ConfigDescription(value="Should the S3 client be pinned to the current EC2 region")
    public HiveClientConfig setPinS3ClientToCurrentRegion(boolean pinS3ClientToCurrentRegion) {
        this.pinS3ClientToCurrentRegion = pinS3ClientToCurrentRegion;
        return this;
    }

    @Deprecated
    public boolean isParquetPredicatePushdownEnabled() {
        return this.parquetPredicatePushdownEnabled;
    }

    @Deprecated
    @Config(value="hive.parquet-predicate-pushdown.enabled")
    public HiveClientConfig setParquetPredicatePushdownEnabled(boolean parquetPredicatePushdownEnabled) {
        this.parquetPredicatePushdownEnabled = parquetPredicatePushdownEnabled;
        return this;
    }

    @Deprecated
    public boolean isParquetOptimizedReaderEnabled() {
        return this.parquetOptimizedReaderEnabled;
    }

    @Deprecated
    @Config(value="hive.parquet-optimized-reader.enabled")
    public HiveClientConfig setParquetOptimizedReaderEnabled(boolean parquetOptimizedReaderEnabled) {
        this.parquetOptimizedReaderEnabled = parquetOptimizedReaderEnabled;
        return this;
    }

    public boolean isUseOrcColumnNames() {
        return this.useOrcColumnNames;
    }

    @Config(value="hive.orc.use-column-names")
    @ConfigDescription(value="Access ORC columns using names from the file")
    public HiveClientConfig setUseOrcColumnNames(boolean useOrcColumnNames) {
        this.useOrcColumnNames = useOrcColumnNames;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxMergeDistance() {
        return this.orcMaxMergeDistance;
    }

    @Config(value="hive.orc.max-merge-distance")
    public HiveClientConfig setOrcMaxMergeDistance(DataSize orcMaxMergeDistance) {
        this.orcMaxMergeDistance = orcMaxMergeDistance;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxBufferSize() {
        return this.orcMaxBufferSize;
    }

    @Config(value="hive.orc.max-buffer-size")
    public HiveClientConfig setOrcMaxBufferSize(DataSize orcMaxBufferSize) {
        this.orcMaxBufferSize = orcMaxBufferSize;
        return this;
    }

    @NotNull
    public DataSize getOrcStreamBufferSize() {
        return this.orcStreamBufferSize;
    }

    @Config(value="hive.orc.stream-buffer-size")
    public HiveClientConfig setOrcStreamBufferSize(DataSize orcStreamBufferSize) {
        this.orcStreamBufferSize = orcStreamBufferSize;
        return this;
    }

    public boolean isAssumeCanonicalPartitionKeys() {
        return this.assumeCanonicalPartitionKeys;
    }

    @Config(value="hive.assume-canonical-partition-keys")
    public HiveClientConfig setAssumeCanonicalPartitionKeys(boolean assumeCanonicalPartitionKeys) {
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        return this;
    }

    public boolean isUseParquetColumnNames() {
        return this.useParquetColumnNames;
    }

    @Config(value="hive.parquet.use-column-names")
    @ConfigDescription(value="Access Parquet columns using names from the file")
    public HiveClientConfig setUseParquetColumnNames(boolean useParquetColumnNames) {
        this.useParquetColumnNames = useParquetColumnNames;
        return this;
    }
}

