/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.parquet.ParquetDataSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsParquetDataSource
implements ParquetDataSource {
    private final String name;
    private final long size;
    private final FSDataInputStream inputStream;

    public HdfsParquetDataSource(Path path, long size, FSDataInputStream inputStream) {
        this.name = path.toString();
        this.size = size;
        this.inputStream = inputStream;
    }

    @Override
    public final long getSize() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public final void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    @Override
    public final void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.readInternal(position, buffer, bufferOffset, bufferLength);
    }

    private void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        try {
            this.inputStream.readFully(position, buffer, bufferOffset, bufferLength);
        }
        catch (PrestoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("HDFS error reading from %s at position %s", this.name, position), (Throwable)e);
        }
    }

    public static HdfsParquetDataSource buildHdfsParquetDataSource(Path path, Configuration configuration, long start, long length) {
        try {
            FileSystem fileSystem = path.getFileSystem(configuration);
            long size = fileSystem.getFileStatus(path).getLen();
            FSDataInputStream inputStream = fileSystem.open(path);
            return new HdfsParquetDataSource(path, size, inputStream);
        }
        catch (Exception e) {
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage()), (Throwable)e);
        }
    }
}

