/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.reader;

import com.facebook.presto.hive.parquet.ParquetCodecFactory;
import com.facebook.presto.hive.parquet.ParquetCorruptionException;
import com.facebook.presto.hive.parquet.reader.ParquetColumnChunkDescriptor;
import com.facebook.presto.hive.parquet.reader.ParquetColumnChunkPageReader;
import com.facebook.presto.hive.parquet.reader.ParquetMetadataReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import parquet.bytes.BytesInput;
import parquet.column.Encoding;
import parquet.column.page.DataPage;
import parquet.column.page.DataPageV1;
import parquet.column.page.DataPageV2;
import parquet.column.page.DictionaryPage;
import parquet.format.DataPageHeader;
import parquet.format.DataPageHeaderV2;
import parquet.format.DictionaryPageHeader;
import parquet.format.PageHeader;
import parquet.format.Util;

public class ParquetColumnChunk
extends ByteArrayInputStream {
    private final ParquetColumnChunkDescriptor descriptor;
    private final ParquetCodecFactory codecFactory;

    public ParquetColumnChunk(ParquetColumnChunkDescriptor descriptor, byte[] data, int offset, ParquetCodecFactory codecFactory) {
        super(data);
        this.descriptor = descriptor;
        this.pos = offset;
        this.codecFactory = codecFactory;
    }

    public ParquetColumnChunkDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected PageHeader readPageHeader() throws IOException {
        return Util.readPageHeader((InputStream)this);
    }

    public ParquetColumnChunkPageReader readAllPages() throws IOException {
        ArrayList<DataPage> pages = new ArrayList<DataPage>();
        DictionaryPage dictionaryPage = null;
        long valueCount = 0L;
        block5: while (valueCount < this.descriptor.getColumnChunkMetaData().getValueCount()) {
            PageHeader pageHeader = this.readPageHeader();
            int uncompressedPageSize = pageHeader.getUncompressed_page_size();
            int compressedPageSize = pageHeader.getCompressed_page_size();
            switch (pageHeader.type) {
                case DICTIONARY_PAGE: {
                    if (dictionaryPage != null) {
                        throw new ParquetCorruptionException("%s has more than one dictionary page in column chunk", this.descriptor.getColumnDescriptor());
                    }
                    dictionaryPage = this.readDictionaryPage(pageHeader, uncompressedPageSize, compressedPageSize);
                    continue block5;
                }
                case DATA_PAGE: {
                    valueCount += this.readDataPageV1(pageHeader, uncompressedPageSize, compressedPageSize, pages);
                    continue block5;
                }
                case DATA_PAGE_V2: {
                    valueCount += this.readDataPageV2(pageHeader, uncompressedPageSize, compressedPageSize, pages);
                    continue block5;
                }
            }
            this.skip(compressedPageSize);
        }
        ParquetCodecFactory.BytesDecompressor decompressor = this.codecFactory.getDecompressor(this.descriptor.getColumnChunkMetaData().getCodec());
        return new ParquetColumnChunkPageReader(decompressor, pages, dictionaryPage);
    }

    public int getPosition() {
        return this.pos;
    }

    public BytesInput getBytesInput(int size) throws IOException {
        BytesInput bytesInput = BytesInput.from((byte[])this.buf, (int)this.pos, (int)size);
        this.pos += size;
        return bytesInput;
    }

    private DictionaryPage readDictionaryPage(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize) throws IOException {
        DictionaryPageHeader dicHeader = pageHeader.getDictionary_page_header();
        return new DictionaryPage(this.getBytesInput(compressedPageSize), uncompressedPageSize, dicHeader.getNum_values(), Encoding.valueOf((String)dicHeader.getEncoding().name()));
    }

    private long readDataPageV1(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize, List<DataPage> pages) throws IOException {
        DataPageHeader dataHeaderV1 = pageHeader.getData_page_header();
        pages.add((DataPage)new DataPageV1(this.getBytesInput(compressedPageSize), dataHeaderV1.getNum_values(), uncompressedPageSize, ParquetMetadataReader.readStats(dataHeaderV1.getStatistics(), this.descriptor.getColumnDescriptor().getType()), Encoding.valueOf((String)dataHeaderV1.getRepetition_level_encoding().name()), Encoding.valueOf((String)dataHeaderV1.getDefinition_level_encoding().name()), Encoding.valueOf((String)dataHeaderV1.getEncoding().name())));
        return dataHeaderV1.getNum_values();
    }

    private long readDataPageV2(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize, List<DataPage> pages) throws IOException {
        DataPageHeaderV2 dataHeaderV2 = pageHeader.getData_page_header_v2();
        int dataSize = compressedPageSize - dataHeaderV2.getRepetition_levels_byte_length() - dataHeaderV2.getDefinition_levels_byte_length();
        pages.add((DataPage)new DataPageV2(dataHeaderV2.getNum_rows(), dataHeaderV2.getNum_nulls(), dataHeaderV2.getNum_values(), this.getBytesInput(dataHeaderV2.getRepetition_levels_byte_length()), this.getBytesInput(dataHeaderV2.getDefinition_levels_byte_length()), Encoding.valueOf((String)dataHeaderV2.getEncoding().name()), this.getBytesInput(dataSize), uncompressedPageSize, ParquetMetadataReader.readStats(dataHeaderV2.getStatistics(), this.descriptor.getColumnDescriptor().getType()), dataHeaderV2.isIs_compressed()));
        return dataHeaderV2.getNum_values();
    }
}

