/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.reader;

import com.facebook.presto.hive.parquet.reader.ParquetColumnReader;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.DoubleType;
import parquet.column.ColumnDescriptor;

public class ParquetDoubleColumnReader
extends ParquetColumnReader {
    public ParquetDoubleColumnReader(ColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    public BlockBuilder createBlockBuilder() {
        return DoubleType.DOUBLE.createBlockBuilder(new BlockBuilderStatus(), this.nextBatchSize);
    }

    @Override
    public void readValues(BlockBuilder blockBuilder, int valueNumber) {
        for (int i = 0; i < valueNumber; ++i) {
            if (this.definitionReader.readLevel() == this.columnDescriptor.getMaxDefinitionLevel()) {
                DoubleType.DOUBLE.writeDouble(blockBuilder, this.valuesReader.readDouble());
                continue;
            }
            blockBuilder.appendNull();
        }
    }

    @Override
    public void skipValues(int offsetNumber) {
        for (int i = 0; i < offsetNumber; ++i) {
            if (this.definitionReader.readLevel() != this.columnDescriptor.getMaxDefinitionLevel()) continue;
            this.valuesReader.readDouble();
        }
    }
}

