/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.WriteBuffers;

public abstract class VectorMapJoinOuterGenerateResultOperator
extends VectorMapJoinGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(VectorMapJoinOuterGenerateResultOperator.class.getName());
    protected transient VectorMapJoinHashMapResult[] hashMapResults;
    protected transient int[] matchs;
    protected transient int[] matchHashMapResultIndices;
    protected transient int[] nonSpills;
    protected transient int[] spills;
    protected transient int[] spillHashMapResultIndices;
    protected transient int[] scratch1;

    public VectorMapJoinOuterGenerateResultOperator() {
    }

    public VectorMapJoinOuterGenerateResultOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
    }

    @Override
    protected void commonSetup(VectorizedRowBatch batch) throws HiveException {
        super.commonSetup(batch);
        VectorMapJoinHashMap baseHashMap = (VectorMapJoinHashMap)this.vectorMapJoinHashTable;
        this.hashMapResults = new VectorMapJoinHashMapResult[1024];
        for (int i = 0; i < this.hashMapResults.length; ++i) {
            this.hashMapResults[i] = baseHashMap.createHashMapResult();
        }
        this.matchs = new int[1024];
        this.matchHashMapResultIndices = new int[1024];
        this.nonSpills = new int[1024];
        this.spills = new int[1024];
        this.spillHashMapResultIndices = new int[1024];
        this.scratch1 = new int[1024];
    }

    protected void outerPerBatchSetup(VectorizedRowBatch batch) {
        for (int column : this.smallTableOutputVectorColumns) {
            ColumnVector smallTableColumn = batch.cols[column];
            smallTableColumn.reset();
        }
        for (int column : this.bigTableOuterKeyOutputVectorColumns) {
            ColumnVector bigTableOuterKeyColumn = batch.cols[column];
            bigTableOuterKeyColumn.reset();
        }
    }

    public int finishOuter(VectorizedRowBatch batch, int[] matchs, int[] matchHashMapResultIndices, int matchCount, int[] nonSpills, int nonSpillCount, int[] spills, int[] spillHashMapResultIndices, int spillCount, VectorMapJoinHashMapResult[] hashMapResults, int hashMapResultCount, int[] scratch1) throws IOException, HiveException {
        int numSel = 0;
        if (matchCount > 0 && this.bigTableFilterExpressions.length > 0) {
            System.arraycopy(matchs, 0, batch.selected, 0, matchCount);
            batch.size = matchCount;
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            if (batch.size < matchCount) {
                int numMatch = 0;
                int[] selected = batch.selected;
                for (int i = 0; i < batch.size; ++i) {
                    if (selected[i] != matchs[numMatch]) continue;
                    matchHashMapResultIndices[numMatch] = matchHashMapResultIndices[i];
                    if (++numMatch == matchCount) break;
                }
                System.arraycopy(batch.selected, 0, matchs, 0, matchCount);
            }
        }
        if (this.bigTableValueExpressions != null) {
            System.arraycopy(nonSpills, 0, batch.selected, 0, nonSpillCount);
            batch.size = nonSpillCount;
            for (VectorExpression ve : this.bigTableValueExpressions) {
                ve.evaluate(batch);
            }
        }
        int[] noMatchs = scratch1;
        int noMatchCount = 0;
        if (matchCount < nonSpillCount) {
            int matchIndex = 0;
            for (int i = 0; i < nonSpillCount; ++i) {
                int candidateIndex = nonSpills[i];
                if (matchIndex < matchCount && candidateIndex == matchs[matchIndex]) {
                    ++matchIndex;
                    continue;
                }
                noMatchs[noMatchCount++] = candidateIndex;
            }
        }
        if (matchCount > 0) {
            numSel = this.generateOuterHashMapMatchResults(batch, matchs, matchHashMapResultIndices, matchCount, hashMapResults, numSel);
        }
        if (noMatchCount > 0) {
            numSel = this.generateOuterHashMapNoMatchResults(batch, noMatchs, noMatchCount, numSel);
        }
        if (spillCount > 0) {
            this.spillHashMapBatch(batch, hashMapResults, spills, spillHashMapResultIndices, spillCount);
        }
        return numSel;
    }

    private void copyOuterHashMapResultToOverflow(VectorizedRowBatch batch, int batchIndex, VectorMapJoinHashMapResult hashMapResult) throws HiveException, IOException {
        WriteBuffers.ByteSegmentRef byteSegmentRef = hashMapResult.first();
        while (byteSegmentRef != null) {
            if (this.bigTableRetainedVectorCopy != null) {
                this.bigTableRetainedVectorCopy.copyByValue(batch, batchIndex, this.overflowBatch, this.overflowBatch.size);
            }
            if (this.bigTableVectorCopyOuterKeys != null) {
                this.bigTableVectorCopyOuterKeys.copyByReference(this.overflowBatch, this.overflowBatch.size, this.overflowBatch, this.overflowBatch.size);
            }
            if (this.smallTableVectorDeserializeRow != null) {
                byte[] bytes = byteSegmentRef.getBytes();
                int offset = (int)byteSegmentRef.getOffset();
                int length = byteSegmentRef.getLength();
                this.smallTableVectorDeserializeRow.setBytes(bytes, offset, length);
                this.smallTableVectorDeserializeRow.deserializeByValue(this.overflowBatch, this.overflowBatch.size);
            }
            ++this.overflowBatch.size;
            if (this.overflowBatch.size == 1024) {
                this.forwardOverflow();
            }
            byteSegmentRef = hashMapResult.next();
        }
    }

    protected int generateOuterHashMapMatchResults(VectorizedRowBatch batch, int[] matchs, int[] matchHashMapResultIndices, int matchSize, VectorMapJoinHashMapResult[] hashMapResults, int numSel) throws IOException, HiveException {
        int[] selected = batch.selected;
        for (int i = 0; i < matchSize; ++i) {
            int batchIndex = matchs[i];
            int hashMapResultIndex = matchHashMapResultIndices[i];
            VectorMapJoinHashMapResult hashMapResult = hashMapResults[hashMapResultIndex];
            if (!hashMapResult.isSingleRow()) {
                this.copyOuterHashMapResultToOverflow(batch, batchIndex, hashMapResult);
                continue;
            }
            WriteBuffers.ByteSegmentRef byteSegmentRef = hashMapResult.first();
            if (this.bigTableVectorCopyOuterKeys != null) {
                this.bigTableVectorCopyOuterKeys.copyByReference(batch, batchIndex, batch, batchIndex);
            }
            if (this.smallTableVectorDeserializeRow != null) {
                byte[] bytes = byteSegmentRef.getBytes();
                int offset = (int)byteSegmentRef.getOffset();
                int length = byteSegmentRef.getLength();
                this.smallTableVectorDeserializeRow.setBytes(bytes, offset, length);
                this.smallTableVectorDeserializeRow.deserializeByValue(batch, batchIndex);
            }
            selected[numSel++] = batchIndex;
        }
        return numSel;
    }

    protected int generateOuterHashMapNoMatchResults(VectorizedRowBatch batch, int[] noMatchs, int noMatchSize, int numSel) throws IOException, HiveException {
        int[] selected = batch.selected;
        if (numSel == 0) {
            ColumnVector colVector;
            for (int column : this.bigTableOuterKeyOutputVectorColumns) {
                colVector = batch.cols[column];
                colVector.isRepeating = true;
                colVector.noNulls = false;
                colVector.isNull[0] = true;
            }
            for (int column : this.smallTableOutputVectorColumns) {
                colVector = batch.cols[column];
                colVector.isRepeating = true;
                colVector.noNulls = false;
                colVector.isNull[0] = true;
            }
            for (int i = 0; i < noMatchSize; ++i) {
                int batchIndex = noMatchs[i];
                selected[numSel++] = batchIndex;
            }
        } else {
            for (int i = 0; i < noMatchSize; ++i) {
                ColumnVector colVector;
                int batchIndex = noMatchs[i];
                for (int column : this.bigTableOuterKeyOutputVectorColumns) {
                    colVector = batch.cols[column];
                    colVector.noNulls = false;
                    colVector.isNull[batchIndex] = true;
                }
                for (int column : this.smallTableOutputVectorColumns) {
                    colVector = batch.cols[column];
                    colVector.noNulls = false;
                    colVector.isNull[batchIndex] = true;
                }
                selected[numSel++] = batchIndex;
            }
        }
        return numSel;
    }

    public int finishOuterRepeated(VectorizedRowBatch batch, JoinUtil.JoinResult joinResult, VectorMapJoinHashMapResult hashMapResult, int[] scratch1) throws IOException, HiveException {
        int numSel = 0;
        if (joinResult == JoinUtil.JoinResult.MATCH && this.bigTableFilterExpressions.length > 0) {
            int[] rememberSelected = scratch1;
            int rememberBatchSize = batch.size;
            if (batch.selectedInUse) {
                System.arraycopy(batch.selected, 0, rememberSelected, 0, batch.size);
            }
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            if (batch.size == 0) {
                joinResult = JoinUtil.JoinResult.NOMATCH;
                if (batch.selectedInUse) {
                    System.arraycopy(rememberSelected, 0, batch.selected, 0, rememberBatchSize);
                }
                batch.size = rememberBatchSize;
            }
        }
        switch (joinResult) {
            case MATCH: {
                if (this.bigTableValueExpressions != null) {
                    for (VectorExpression ve : this.bigTableValueExpressions) {
                        ve.evaluate(batch);
                    }
                }
                numSel = this.generateHashMapResultRepeatedAll(batch, hashMapResult);
                break;
            }
            case SPILL: {
                this.spillBatchRepeated(batch, hashMapResult);
                break;
            }
            case NOMATCH: {
                if (this.bigTableValueExpressions != null) {
                    for (VectorExpression ve : this.bigTableValueExpressions) {
                        ve.evaluate(batch);
                    }
                }
                numSel = this.generateOuterNullsRepeatedAll(batch);
            }
        }
        return numSel;
    }

    protected int generateOuterNullsRepeatedAll(VectorizedRowBatch batch) throws HiveException {
        ColumnVector colVector;
        int[] selected = batch.selected;
        boolean selectedInUse = batch.selectedInUse;
        if (!batch.selectedInUse) {
            for (int i = 0; i < batch.size; ++i) {
                selected[i] = i;
            }
            batch.selectedInUse = true;
        }
        for (int column : this.smallTableOutputVectorColumns) {
            colVector = batch.cols[column];
            colVector.noNulls = false;
            colVector.isNull[0] = true;
            colVector.isRepeating = true;
        }
        for (int column : this.bigTableOuterKeyOutputVectorColumns) {
            colVector = batch.cols[column];
            colVector.noNulls = false;
            colVector.isNull[0] = true;
            colVector.isRepeating = true;
        }
        return batch.size;
    }
}

