/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class NullRowsInputFormat
implements InputFormat<NullWritable, NullWritable>,
JobConfigurable {
    static final int MAX_ROW = 100;
    static final Log LOG = LogFactory.getLog(NullRowsRecordReader.class.getName());

    public RecordReader<NullWritable, NullWritable> getRecordReader(InputSplit arg0, JobConf arg1, Reporter arg2) throws IOException {
        return new NullRowsRecordReader();
    }

    public InputSplit[] getSplits(JobConf arg0, int arg1) throws IOException {
        InputSplit[] ret = new InputSplit[]{new DummyInputSplit()};
        LOG.info("Calculating splits");
        return ret;
    }

    public void configure(JobConf job) {
        LOG.info("Using null rows input format");
    }

    public static class NullRowsRecordReader
    implements RecordReader<NullWritable, NullWritable> {
        private int counter;

        public void close() throws IOException {
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public NullWritable createValue() {
            return NullWritable.get();
        }

        public long getPos() throws IOException {
            return this.counter;
        }

        public float getProgress() throws IOException {
            return (float)this.counter / 100.0f;
        }

        public boolean next(NullWritable arg0, NullWritable arg1) throws IOException {
            return this.counter++ < 100;
        }
    }

    public static class DummyInputSplit
    implements InputSplit {
        public long getLength() throws IOException {
            return 1L;
        }

        public String[] getLocations() throws IOException {
            return new String[0];
        }

        public void readFields(DataInput arg0) throws IOException {
        }

        public void write(DataOutput arg0) throws IOException {
        }
    }
}

