/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats.fs;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.stats.StatsCollectionTaskIndependent;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hive.com.esotericsoftware.kryo.io.Output;

public class FSStatsPublisher
implements StatsPublisher,
StatsCollectionTaskIndependent {
    private Configuration conf;
    private final Log LOG = LogFactory.getLog(this.getClass().getName());
    private Map<String, Map<String, String>> statsMap;

    @Override
    public boolean init(Configuration hconf) {
        Path statsDir = new Path(hconf.get("hive.stats.tmp.loc"));
        this.LOG.debug("Initing FSStatsPublisher with : " + statsDir);
        try {
            statsDir.getFileSystem(hconf).mkdirs(statsDir);
            this.LOG.info("created : " + statsDir);
            return true;
        }
        catch (IOException e) {
            this.LOG.error(e);
            return false;
        }
    }

    @Override
    public boolean connect(Configuration hconf) {
        this.conf = hconf;
        Path statsDir = new Path(hconf.get("hive.stats.tmp.loc"));
        this.LOG.debug("Connecting to : " + statsDir);
        this.statsMap = new HashMap<String, Map<String, String>>();
        try {
            return statsDir.getFileSystem(this.conf).exists(statsDir);
        }
        catch (IOException e) {
            this.LOG.error(e);
            return false;
        }
    }

    @Override
    public boolean publishStat(String partKV, Map<String, String> stats) {
        this.LOG.debug("Putting in map : " + partKV + "\t" + stats);
        HashMap<String, String> cpy = new HashMap<String, String>(stats);
        Map<String, String> statMap = this.statsMap.get(partKV);
        if (null != statMap) {
            for (Map.Entry<String, String> e : statMap.entrySet()) {
                cpy.put(e.getKey(), String.valueOf(Long.valueOf(e.getValue()) + Long.valueOf((String)cpy.get(e.getKey()))));
            }
        }
        this.statsMap.put(partKV, cpy);
        return true;
    }

    @Override
    public boolean closeConnection() {
        Path statsDir = new Path(this.conf.get("hive.stats.tmp.loc"));
        try {
            Path statsFile = new Path(statsDir, "tmpstats-" + this.conf.getInt("mapred.task.partition", 0));
            this.LOG.debug("About to create stats file for this task : " + statsFile);
            Output output = new Output((OutputStream)statsFile.getFileSystem(this.conf).create(statsFile, true));
            this.LOG.info("Created file : " + statsFile);
            this.LOG.info("Writing stats in it : " + this.statsMap);
            Utilities.runtimeSerializationKryo.get().writeObject(output, this.statsMap);
            output.close();
            return true;
        }
        catch (IOException e) {
            this.LOG.error(e);
            return false;
        }
    }
}

