/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.com.esotericsoftware.kryo.serializers;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import org.apache.hive.com.esotericsoftware.kryo.Kryo;
import org.apache.hive.com.esotericsoftware.kryo.Registration;
import org.apache.hive.com.esotericsoftware.kryo.Serializer;
import org.apache.hive.com.esotericsoftware.kryo.io.Input;
import org.apache.hive.com.esotericsoftware.kryo.io.Output;
import org.apache.hive.com.esotericsoftware.minlog.Log;

public class DefaultArraySerializers {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectArraySerializer
    extends Serializer<Object[]> {
        private boolean elementsAreSameType;
        private boolean elementsCanBeNull = true;
        private Class[] generics;
        private final Class type;
        private final Kryo kryo;

        public ObjectArraySerializer(Kryo kryo, Class type) {
            boolean isFinal;
            this.setAcceptsNull(true);
            this.kryo = kryo;
            this.type = type;
            Class<?> componentType = type.getComponentType();
            boolean bl = isFinal = 0 != (componentType.getModifiers() & 0x10);
            if (isFinal) {
                this.setElementsAreSameType(true);
            }
        }

        @Override
        public void write(Kryo kryo, Output output, Object[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            Class<?> elementClass = object.getClass().getComponentType();
            if (this.elementsAreSameType || Modifier.isFinal(elementClass.getModifiers())) {
                Serializer elementSerializer = kryo.getSerializer(elementClass);
                elementSerializer.setGenerics(kryo, this.generics);
                int n = object.length;
                for (int i = 0; i < n; ++i) {
                    if (this.elementsCanBeNull) {
                        kryo.writeObjectOrNull(output, object[i], elementSerializer);
                        continue;
                    }
                    kryo.writeObject(output, object[i], elementSerializer);
                }
            } else {
                int n = object.length;
                for (int i = 0; i < n; ++i) {
                    if (object[i] != null) {
                        Serializer serializer = kryo.getSerializer(object[i].getClass());
                        serializer.setGenerics(kryo, this.generics);
                    }
                    kryo.writeClassAndObject(output, object[i]);
                }
            }
        }

        @Override
        public Object[] read(Kryo kryo, Input input, Class<Object[]> type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            Object[] object = (Object[])Array.newInstance(type.getComponentType(), length - 1);
            kryo.reference(object);
            Class<?> elementClass = object.getClass().getComponentType();
            if (this.elementsAreSameType || Modifier.isFinal(elementClass.getModifiers())) {
                Serializer elementSerializer = kryo.getSerializer(elementClass);
                elementSerializer.setGenerics(kryo, this.generics);
                int n = object.length;
                for (int i = 0; i < n; ++i) {
                    object[i] = this.elementsCanBeNull ? kryo.readObjectOrNull(input, elementClass, elementSerializer) : kryo.readObject(input, elementClass, elementSerializer);
                }
            } else {
                int n = object.length;
                for (int i = 0; i < n; ++i) {
                    Registration registration = kryo.readClass(input);
                    if (registration != null) {
                        registration.getSerializer().setGenerics(kryo, this.generics);
                        object[i] = kryo.readObject(input, registration.getType(), registration.getSerializer());
                        continue;
                    }
                    object[i] = null;
                }
            }
            return object;
        }

        @Override
        public Object[] copy(Kryo kryo, Object[] original) {
            Object[] copy = (Object[])Array.newInstance(original.getClass().getComponentType(), original.length);
            int n = original.length;
            for (int i = 0; i < n; ++i) {
                copy[i] = kryo.copy(original[i]);
            }
            return copy;
        }

        public void setElementsCanBeNull(boolean elementsCanBeNull) {
            this.elementsCanBeNull = elementsCanBeNull;
        }

        public void setElementsAreSameType(boolean elementsAreSameType) {
            this.elementsAreSameType = elementsAreSameType;
        }

        @Override
        public void setGenerics(Kryo kryo, Class[] generics) {
            if (Log.TRACE) {
                Log.trace("kryo", "setting generics for ObjectArraySerializer");
            }
            this.generics = generics;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringArraySerializer
    extends Serializer<String[]> {
        public StringArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, String[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                output.writeString(object[i]);
            }
        }

        @Override
        public String[] read(Kryo kryo, Input input, Class<String[]> type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            String[] array = new String[--length];
            for (int i = 0; i < length; ++i) {
                array[i] = input.readString();
            }
            return array;
        }

        @Override
        public String[] copy(Kryo kryo, String[] original) {
            String[] copy = new String[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BooleanArraySerializer
    extends Serializer<boolean[]> {
        public BooleanArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, boolean[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                output.writeBoolean(object[i]);
            }
        }

        @Override
        public boolean[] read(Kryo kryo, Input input, Class<boolean[]> type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            boolean[] array = new boolean[--length];
            for (int i = 0; i < length; ++i) {
                array[i] = input.readBoolean();
            }
            return array;
        }

        @Override
        public boolean[] copy(Kryo kryo, boolean[] original) {
            boolean[] copy = new boolean[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleArraySerializer
    extends Serializer<double[]> {
        public DoubleArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, double[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeDoubles(object);
        }

        @Override
        public double[] read(Kryo kryo, Input input, Class<double[]> type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readDoubles(length - 1);
        }

        @Override
        public double[] copy(Kryo kryo, double[] original) {
            double[] copy = new double[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharArraySerializer
    extends Serializer<char[]> {
        public CharArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, char[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeChars(object);
        }

        @Override
        public char[] read(Kryo kryo, Input input, Class<char[]> type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readChars(length - 1);
        }

        @Override
        public char[] copy(Kryo kryo, char[] original) {
            char[] copy = new char[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShortArraySerializer
    extends Serializer<short[]> {
        public ShortArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, short[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeShorts(object);
        }

        @Override
        public short[] read(Kryo kryo, Input input, Class<short[]> type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readShorts(length - 1);
        }

        @Override
        public short[] copy(Kryo kryo, short[] original) {
            short[] copy = new short[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongArraySerializer
    extends Serializer<long[]> {
        public LongArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, long[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeLongs(object, false);
        }

        @Override
        public long[] read(Kryo kryo, Input input, Class<long[]> type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readLongs(length - 1, false);
        }

        @Override
        public long[] copy(Kryo kryo, long[] original) {
            long[] copy = new long[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatArraySerializer
    extends Serializer<float[]> {
        public FloatArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, float[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeFloats(object);
        }

        @Override
        public float[] read(Kryo kryo, Input input, Class<float[]> type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readFloats(length - 1);
        }

        @Override
        public float[] copy(Kryo kryo, float[] original) {
            float[] copy = new float[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntArraySerializer
    extends Serializer<int[]> {
        public IntArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, int[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeInts(object, false);
        }

        @Override
        public int[] read(Kryo kryo, Input input, Class<int[]> type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readInts(length - 1, false);
        }

        @Override
        public int[] copy(Kryo kryo, int[] original) {
            int[] copy = new int[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteArraySerializer
    extends Serializer<byte[]> {
        public ByteArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, byte[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeBytes(object);
        }

        @Override
        public byte[] read(Kryo kryo, Input input, Class<byte[]> type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input.readBytes(length - 1);
        }

        @Override
        public byte[] copy(Kryo kryo, byte[] original) {
            byte[] copy = new byte[original.length];
            System.arraycopy(original, 0, copy, 0, copy.length);
            return copy;
        }
    }
}

