/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.reader.StreamReaders;
import com.facebook.presto.orc.stream.BooleanStream;
import com.facebook.presto.orc.stream.LongStream;
import com.facebook.presto.orc.stream.MissingStreamSource;
import com.facebook.presto.orc.stream.StreamSource;
import com.facebook.presto.orc.stream.StreamSources;
import com.facebook.presto.spi.block.ArrayBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slices;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;

public class MapStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private final StreamReader keyStreamReader;
    private final StreamReader valueStreamReader;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private StreamSource<BooleanStream> presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
    @Nullable
    private BooleanStream presentStream;
    @Nonnull
    private StreamSource<LongStream> lengthStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
    @Nullable
    private LongStream lengthStream;
    private boolean rowGroupOpen;

    public MapStreamReader(StreamDescriptor streamDescriptor, DateTimeZone hiveStorageTimeZone) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.keyStreamReader = StreamReaders.createStreamReader(streamDescriptor.getNestedStreams().get(0), hiveStorageTimeZone);
        this.valueStreamReader = StreamReaders.createStreamReader(streamDescriptor.getNestedStreams().get(1), hiveStorageTimeZone);
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        Block values;
        Block keys;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException("Value is not null but data stream is not present");
                }
                long entrySkipSize = this.lengthStream.sum(this.readOffset);
                this.keyStreamReader.prepareNextRead(Ints.checkedCast((long)entrySkipSize));
                this.valueStreamReader.prepareNextRead(Ints.checkedCast((long)entrySkipSize));
            }
        }
        int[] lengths = new int[this.nextBatchSize];
        boolean[] nullVector = new boolean[this.nextBatchSize];
        if (this.presentStream == null) {
            if (this.lengthStream == null) {
                throw new OrcCorruptionException("Value is not null but data stream is not present");
            }
            this.lengthStream.nextIntVector(this.nextBatchSize, lengths);
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, nullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException("Value is not null but data stream is not present");
                }
                this.lengthStream.nextIntVector(this.nextBatchSize, lengths, nullVector);
            }
        }
        Type keyType = (Type)type.getTypeParameters().get(0);
        Type valueType = (Type)type.getTypeParameters().get(1);
        int entryCount = 0;
        for (int length : lengths) {
            entryCount += length;
        }
        if (entryCount > 0) {
            this.keyStreamReader.prepareNextRead(entryCount);
            this.valueStreamReader.prepareNextRead(entryCount);
            keys = this.keyStreamReader.readBlock(keyType);
            values = this.valueStreamReader.readBlock(valueType);
        } else {
            keys = keyType.createBlockBuilder(new BlockBuilderStatus(), 0).build();
            values = valueType.createBlockBuilder(new BlockBuilderStatus(), 1).build();
        }
        InterleavedBlock keyValueBlock = MapStreamReader.createKeyValueBlock(keys, values, lengths);
        lengths[0] = lengths[0] * 2;
        for (int i = 1; i < lengths.length; ++i) {
            lengths[i] = lengths[i - 1] + lengths[i] * 2;
        }
        ArrayBlock arrayBlock = new ArrayBlock((Block)keyValueBlock, Slices.wrappedIntArray((int[])lengths), 0, Slices.wrappedBooleanArray((boolean[])nullVector));
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return arrayBlock;
    }

    private static InterleavedBlock createKeyValueBlock(Block keys, Block values, int[] lengths) {
        if (!MapStreamReader.hasNull(keys)) {
            return new InterleavedBlock(new Block[]{keys, values});
        }
        IntArrayList nonNullPositions = new IntArrayList(keys.getPositionCount());
        int position = 0;
        for (int mapIndex = 0; mapIndex < lengths.length; ++mapIndex) {
            int length = lengths[mapIndex];
            for (int entryIndex = 0; entryIndex < length; ++entryIndex) {
                if (keys.isNull(position)) {
                    int n = mapIndex;
                    lengths[n] = lengths[n] - 1;
                } else {
                    nonNullPositions.add(position);
                }
                ++position;
            }
        }
        Block newKeys = keys.copyPositions((List)nonNullPositions);
        Block newValues = values.copyPositions((List)nonNullPositions);
        return new InterleavedBlock(new Block[]{newKeys, newValues});
    }

    private static boolean hasNull(Block keys) {
        for (int position = 0; position < keys.getPositionCount(); ++position) {
            if (!keys.isNull(position)) continue;
            return true;
        }
        return false;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(StreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingStreamSource.missingStreamSource(BooleanStream.class);
        this.lengthStreamSource = MissingStreamSource.missingStreamSource(LongStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.keyStreamReader.startStripe(dictionaryStreamSources, encoding);
        this.valueStreamReader.startStripe(dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(StreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanStream.class);
        this.lengthStreamSource = dataStreamSources.getStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.keyStreamReader.startRowGroup(dataStreamSources);
        this.valueStreamReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

