/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.checkpoint.ByteArrayStreamCheckpoint;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.OrcStreamUtils;
import com.facebook.presto.orc.stream.ValueStream;
import java.io.IOException;
import java.util.Objects;

public class ByteArrayStream
implements ValueStream<ByteArrayStreamCheckpoint> {
    private final OrcInputStream inputStream;

    public ByteArrayStream(OrcInputStream inputStream) {
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream is null");
    }

    public byte[] next(int length) throws IOException {
        byte[] data = new byte[length];
        OrcStreamUtils.readFully(this.inputStream, data, 0, length);
        return data;
    }

    public void next(int length, byte[] data) throws IOException {
        OrcStreamUtils.readFully(this.inputStream, data, 0, length);
    }

    @Override
    public Class<ByteArrayStreamCheckpoint> getCheckpointType() {
        return ByteArrayStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(ByteArrayStreamCheckpoint checkpoint) throws IOException {
        this.inputStream.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
    }

    @Override
    public void skip(long skipSize) throws IOException {
        OrcStreamUtils.skipFully(this.inputStream, skipSize);
    }
}

