/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.typeconverter.impl;

import com.facebook.presto.hive.$internal.jodd.typeconverter.TypeConversionException;
import com.facebook.presto.hive.$internal.jodd.typeconverter.TypeConverter;
import com.facebook.presto.hive.$internal.jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortConverter
implements TypeConverter<Short> {
    @Override
    public Short convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Short.class) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        try {
            String stringValue = value.toString().trim();
            if (StringUtil.startsWithChar(stringValue, '+')) {
                stringValue = stringValue.substring(1);
            }
            return Short.valueOf(stringValue);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

