/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;

public class VectorCopyRow {
    protected static final transient Log LOG = LogFactory.getLog(VectorCopyRow.class);
    private CopyRow[] subRowToBatchCopiersByValue;
    private CopyRow[] subRowToBatchCopiersByReference;

    public void init(VectorColumnMapping columnMapping) {
        int count = columnMapping.getCount();
        this.subRowToBatchCopiersByValue = new CopyRow[count];
        this.subRowToBatchCopiersByReference = new CopyRow[count];
        for (int i = 0; i < count; ++i) {
            int inputColumn = columnMapping.getInputColumns()[i];
            int outputColumn = columnMapping.getOutputColumns()[i];
            String typeName = columnMapping.getTypeNames()[i];
            CopyRow copyRowByValue = null;
            BytesCopyRowByReference copyRowByReference = null;
            if (VectorizationContext.isIntFamily(typeName) || VectorizationContext.isDatetimeFamily(typeName)) {
                copyRowByValue = new LongCopyRow(inputColumn, outputColumn);
            } else if (VectorizationContext.isFloatFamily(typeName)) {
                copyRowByValue = new DoubleCopyRow(inputColumn, outputColumn);
            } else if (VectorizationContext.isStringFamily(typeName)) {
                copyRowByValue = new BytesCopyRowByValue(inputColumn, outputColumn);
                copyRowByReference = new BytesCopyRowByReference(inputColumn, outputColumn);
            } else if (VectorizationContext.decimalTypePattern.matcher(typeName).matches()) {
                copyRowByValue = new DecimalCopyRow(inputColumn, outputColumn);
            } else {
                throw new RuntimeException("Cannot allocate vector copy row for " + typeName);
            }
            this.subRowToBatchCopiersByValue[i] = copyRowByValue;
            this.subRowToBatchCopiersByReference[i] = copyRowByReference == null ? copyRowByValue : copyRowByReference;
        }
    }

    public void copyByValue(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
        for (CopyRow copyRow : this.subRowToBatchCopiersByValue) {
            copyRow.copy(inBatch, inBatchIndex, outBatch, outBatchIndex);
        }
    }

    public void copyByReference(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
        for (CopyRow copyRow : this.subRowToBatchCopiersByReference) {
            copyRow.copy(inBatch, inBatchIndex, outBatch, outBatchIndex);
        }
    }

    private class DecimalCopyRow
    extends CopyRow {
        DecimalCopyRow(int inColumnIndex, int outColumnIndex) {
            super(inColumnIndex, outColumnIndex);
        }

        @Override
        void copy(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
            DecimalColumnVector inColVector = (DecimalColumnVector)inBatch.cols[this.inColumnIndex];
            DecimalColumnVector outColVector = (DecimalColumnVector)outBatch.cols[this.outColumnIndex];
            if (inColVector.isRepeating) {
                if (inColVector.noNulls || !inColVector.isNull[0]) {
                    outColVector.set(outBatchIndex, inColVector.vector[0]);
                } else {
                    VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
                }
            } else if (inColVector.noNulls || !inColVector.isNull[inBatchIndex]) {
                outColVector.set(outBatchIndex, inColVector.vector[inBatchIndex]);
            } else {
                VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
            }
        }
    }

    private class BytesCopyRowByReference
    extends AbstractBytesCopyRow {
        BytesCopyRowByReference(int inColumnIndex, int outColumnIndex) {
            super(inColumnIndex, outColumnIndex);
        }

        @Override
        void copy(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
            BytesColumnVector inColVector = (BytesColumnVector)inBatch.cols[this.inColumnIndex];
            BytesColumnVector outColVector = (BytesColumnVector)outBatch.cols[this.outColumnIndex];
            if (inColVector.isRepeating) {
                if (inColVector.noNulls || !inColVector.isNull[0]) {
                    outColVector.setRef(outBatchIndex, inColVector.vector[0], inColVector.start[0], inColVector.length[0]);
                } else {
                    VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
                }
            } else if (inColVector.noNulls || !inColVector.isNull[inBatchIndex]) {
                outColVector.setRef(outBatchIndex, inColVector.vector[inBatchIndex], inColVector.start[inBatchIndex], inColVector.length[inBatchIndex]);
            } else {
                VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
            }
        }
    }

    private class BytesCopyRowByValue
    extends AbstractBytesCopyRow {
        BytesCopyRowByValue(int inColumnIndex, int outColumnIndex) {
            super(inColumnIndex, outColumnIndex);
        }

        @Override
        void copy(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
            BytesColumnVector inColVector = (BytesColumnVector)inBatch.cols[this.inColumnIndex];
            BytesColumnVector outColVector = (BytesColumnVector)outBatch.cols[this.outColumnIndex];
            if (inColVector.isRepeating) {
                if (inColVector.noNulls || !inColVector.isNull[0]) {
                    outColVector.setVal(outBatchIndex, inColVector.vector[0], inColVector.start[0], inColVector.length[0]);
                } else {
                    VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
                }
            } else if (inColVector.noNulls || !inColVector.isNull[inBatchIndex]) {
                outColVector.setVal(outBatchIndex, inColVector.vector[inBatchIndex], inColVector.start[inBatchIndex], inColVector.length[inBatchIndex]);
            } else {
                VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
            }
        }
    }

    private abstract class AbstractBytesCopyRow
    extends CopyRow {
        AbstractBytesCopyRow(int inColumnIndex, int outColumnIndex) {
            super(inColumnIndex, outColumnIndex);
        }
    }

    private class DoubleCopyRow
    extends CopyRow {
        DoubleCopyRow(int inColumnIndex, int outColumnIndex) {
            super(inColumnIndex, outColumnIndex);
        }

        @Override
        void copy(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
            DoubleColumnVector inColVector = (DoubleColumnVector)inBatch.cols[this.inColumnIndex];
            DoubleColumnVector outColVector = (DoubleColumnVector)outBatch.cols[this.outColumnIndex];
            if (inColVector.isRepeating) {
                if (inColVector.noNulls || !inColVector.isNull[0]) {
                    outColVector.vector[outBatchIndex] = inColVector.vector[0];
                } else {
                    VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
                }
            } else if (inColVector.noNulls || !inColVector.isNull[inBatchIndex]) {
                outColVector.vector[outBatchIndex] = inColVector.vector[inBatchIndex];
            } else {
                VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
            }
        }
    }

    private class LongCopyRow
    extends CopyRow {
        LongCopyRow(int inColumnIndex, int outColumnIndex) {
            super(inColumnIndex, outColumnIndex);
        }

        @Override
        void copy(VectorizedRowBatch inBatch, int inBatchIndex, VectorizedRowBatch outBatch, int outBatchIndex) {
            LongColumnVector inColVector = (LongColumnVector)inBatch.cols[this.inColumnIndex];
            LongColumnVector outColVector = (LongColumnVector)outBatch.cols[this.outColumnIndex];
            if (inColVector.isRepeating) {
                if (inColVector.noNulls || !inColVector.isNull[0]) {
                    outColVector.vector[outBatchIndex] = inColVector.vector[0];
                } else {
                    VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
                }
            } else if (inColVector.noNulls || !inColVector.isNull[inBatchIndex]) {
                outColVector.vector[outBatchIndex] = inColVector.vector[inBatchIndex];
            } else {
                VectorizedBatchUtil.setNullColIsNullValue(outColVector, outBatchIndex);
            }
        }
    }

    private abstract class CopyRow {
        protected int inColumnIndex;
        protected int outColumnIndex;

        CopyRow(int inColumnIndex, int outColumnIndex) {
            this.inColumnIndex = inColumnIndex;
            this.outColumnIndex = outColumnIndex;
        }

        abstract void copy(VectorizedRowBatch var1, int var2, VectorizedRowBatch var3, int var4);
    }
}

