/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.checkpoint.DoubleStreamCheckpoint;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.OrcStreamUtils;
import com.facebook.presto.orc.stream.ValueStream;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;

public class DoubleStream
implements ValueStream<DoubleStreamCheckpoint> {
    private final OrcInputStream input;
    private final byte[] buffer = new byte[8];
    private final Slice slice = Slices.wrappedBuffer((byte[])this.buffer);

    public DoubleStream(OrcInputStream input) {
        this.input = input;
    }

    @Override
    public Class<DoubleStreamCheckpoint> getCheckpointType() {
        return DoubleStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(DoubleStreamCheckpoint checkpoint) throws IOException {
        this.input.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
    }

    @Override
    public void skip(long items) throws IOException {
        long length = items * 8L;
        OrcStreamUtils.skipFully(this.input, length);
    }

    public double next() throws IOException {
        OrcStreamUtils.readFully(this.input, this.buffer, 0, 8);
        return this.slice.getDouble(0);
    }

    public void nextVector(Type type, int items, BlockBuilder builder) throws IOException {
        for (int i = 0; i < items; ++i) {
            type.writeDouble(builder, this.next());
        }
    }

    public void nextVector(Type type, long items, BlockBuilder builder, boolean[] isNull) throws IOException {
        int i = 0;
        while ((long)i < items) {
            if (isNull[i]) {
                builder.appendNull();
            } else {
                type.writeDouble(builder, this.next());
            }
            ++i;
        }
    }
}

